/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.agent;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Service;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.message.JobExecute;
import com.hazelcast.core.HazelcastInstance;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.Logger;

public abstract class AgentService
extends Service {
    static Logger logger = LogUtils.getLogger(AgentService.class);
    private static AgentService service = null;
    protected Listener listener = null;

    public static AgentService getService(HazelcastInstance hazelcast) throws ServiceException {
        String className;
        if (service == null && !StringUtils.isNullOrEmpty(className = Service.getClassName((String)Configs.get("beyondcron.agent.service", Program.getOs()), Service.Type.AGENT))) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new ServiceException(Localise.format("agent service class does not exist - %s", className));
            }
            catch (ClassCastException e) {
                throw new ServiceException(Localise.format("class does not implement AgentService - %s", className));
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(HazelcastInstance.class);
                service = (AgentService)constructor.newInstance(hazelcast);
                Configs.addConfigs(clazz);
            }
            catch (NoSuchMethodException e) {
                try {
                    service = (AgentService)clazz.newInstance();
                }
                catch (Exception e1) {
                    throw new ServiceException(Localise.format("could not load agent service %s - %s", className, e.getMessage()));
                }
            }
            catch (InvocationTargetException e) {
                throw new ServiceException(Localise.format("could not load agent service %s - %s", className, e.getCause().getMessage()));
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format("could not load agent service %s - %s", className, e.getMessage()), e);
            }
            service.connect();
        }
        return service;
    }

    protected AgentService(String name) {
        super(Service.Type.AGENT, name, true);
    }

    public abstract Job.Type getJobType();

    public abstract void close() throws ServiceException;

    public abstract void execute(JobExecute var1) throws ServiceException;

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void notifyListener(ServiceException exception) {
        logger.error(exception.getMessage());
        if (this.listener != null) {
            this.listener.agentException(exception);
        }
    }

    protected void notifyListener(Status status) {
        if (this.listener != null) {
            this.listener.agentUpdate(status);
        }
    }

    public static interface Listener {
        public void agentException(ServiceException var1);

        public void agentUpdate(Status var1);
    }
}

