/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.calendar;

import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.calendar.ICalendarInstance;
import com.beyondcron.core.job.Job;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.model.CalendarException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.util.TimeZones;
import org.apache.logging.log4j.Logger;
import org.quartz.Calendar;

public class CalendarInstance
implements Comparable<CalendarInstance>,
Calendar,
Serializable {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LogUtils.getLogger(CalendarInstance.class);
    private static final String INSTANCE_NAME_FORMAT = "%s-%s";
    public static final int MAXIMUM_CACHE_PERIOD_DAYS = 1825;
    public static final int MAXIMUM_CACHE_ENTRIES = 100;
    private String name = null;
    private String description = "";
    private transient PeriodList periodsCache = null;
    private transient net.fortuna.ical4j.model.Period periodsCachePeriod = null;
    private int periodsCacheDuration = 7;
    private Set<ICalendarInstance> inclusiveCalendars = new TreeSet<ICalendarInstance>();
    private Set<ICalendarInstance> exclusiveCalendars = new TreeSet<ICalendarInstance>();

    private CalendarInstance() {
    }

    public CalendarInstance(String name) throws CalendarException {
        this.name = name;
    }

    public Object clone() {
        CalendarInstance clone = new CalendarInstance();
        clone.name = this.name;
        clone.inclusiveCalendars.addAll(this.inclusiveCalendars);
        clone.exclusiveCalendars.addAll(this.exclusiveCalendars);
        return clone;
    }

    public void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public void clear() {
        this.inclusiveCalendars.clear();
        this.exclusiveCalendars.clear();
    }

    public static String getInstanceName(Job job) {
        return String.format(INSTANCE_NAME_FORMAT, job.getCalendar().toString(), job.getTimeZone().getID());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.isNullOrEmpty(description) ? "" : description;
    }

    public boolean hasInclusiveCalendar() {
        return !this.inclusiveCalendars.isEmpty();
    }

    public boolean addInclusiveCalendar(ICalendarInstance calendar) {
        boolean changed = this.inclusiveCalendars.add(calendar);
        this.clearCache();
        return changed;
    }

    public boolean addExclusiveCalendar(ICalendarInstance calendar) {
        boolean changed = this.exclusiveCalendars.add(calendar);
        this.clearCache();
        return changed;
    }

    public Calendar getBaseCalendar() {
        return null;
    }

    public void setBaseCalendar(Calendar calendar) {
        logger.error("setBaseCalendar call ignored for calendar {}", (Object)calendar.getDescription());
    }

    public PeriodList getPeriodList(net.fortuna.ical4j.model.Period period) {
        PeriodList periods = new PeriodList();
        for (ICalendarInstance calendar : this.inclusiveCalendars) {
            periods = periods.add(calendar.getPeriodList(period));
        }
        if (periods.size() < 1) {
            return periods;
        }
        for (ICalendarInstance calendar : this.exclusiveCalendars) {
            periods = periods.subtract(calendar.getPeriodList(period));
        }
        return periods.normalise();
    }

    public PeriodList getPeriodList(Date date) {
        return this.getPeriodList(date, false);
    }

    public PeriodList getPeriodList(Date date, boolean openEnded) {
        java.util.Calendar start = java.util.Calendar.getInstance(TimeZones.getDefault());
        java.util.Calendar end = java.util.Calendar.getInstance(TimeZones.getDefault());
        if (this.periodsCache != null && this.periodsCachePeriod.includes(date) && (openEnded || CalendarInstance.getLastPeriod(this.periodsCache).getStart().after(date))) {
            return this.periodsCache;
        }
        start.setTime(date);
        start.add(11, -1);
        end.setTime(date);
        end.add(5, this.periodsCacheDuration);
        this.periodsCachePeriod = new net.fortuna.ical4j.model.Period(new DateTime(start.getTime()), new DateTime(end.getTime()));
        this.periodsCache = this.getPeriodList(this.periodsCachePeriod);
        if (!openEnded) {
            while (this.periodsCache.size() < 1 || CalendarInstance.getLastPeriod(this.periodsCache).getStart().before(date)) {
                end.setTime((Date)this.periodsCachePeriod.getEnd());
                end.add(5, 7);
                net.fortuna.ical4j.model.Period period = new net.fortuna.ical4j.model.Period(this.periodsCachePeriod.getEnd(), new DateTime(end.getTime()));
                this.periodsCache = this.periodsCache.add(this.getPeriodList(period));
                this.periodsCachePeriod = this.periodsCachePeriod.add(period);
                if (this.getDurationDays(this.periodsCachePeriod.getDuration()) <= 1825) continue;
            }
        }
        this.periodsCacheDuration = this.getDurationDays(this.periodsCachePeriod.getDuration());
        if (this.periodsCacheDuration > 1 && this.periodsCache.size() > 100) {
            this.periodsCacheDuration = 100 / (this.periodsCache.size() / this.getDurationDays(this.periodsCachePeriod.getDuration()));
            if (this.periodsCacheDuration < 1) {
                this.periodsCacheDuration = 1;
            }
        }
        logger.trace("cache update: {}; period: {} days; size: {}", (Object)this.name, (Object)this.periodsCacheDuration, (Object)this.periodsCache.size());
        return this.periodsCache;
    }

    private int getDurationDays(TemporalAmount duration) {
        if (duration instanceof Period) {
            return ((Period)duration).getDays();
        }
        if (duration instanceof Duration) {
            return (int)(((Duration)duration).getSeconds() / Period.Unit.DAY.getUnitInSeconds());
        }
        throw new UnsupportedTemporalTypeException("Unsupported amount: " + duration.getClass().getName());
    }

    public long getNextIncludedTime(long timeStamp) {
        Date date = new Date(timeStamp);
        for (Object obj : this.getPeriodList(date)) {
            net.fortuna.ical4j.model.Period period = (net.fortuna.ical4j.model.Period)obj;
            if (period.getStart().after(date)) {
                return period.getStart().getTime();
            }
            if (!period.getEnd().after(date)) continue;
            return timeStamp;
        }
        logger.warn("could not determine next included time: {} {}", (Object)this.getName(), (Object)date);
        return 0L;
    }

    public Date getNextStartTime(Date afterTime) {
        for (Object obj : this.getPeriodList(afterTime)) {
            DateTime startTime = ((net.fortuna.ical4j.model.Period)obj).getStart();
            if (!startTime.after(afterTime)) continue;
            return startTime;
        }
        logger.warn("could not determine next period start time: {} {}", (Object)this.getName(), (Object)afterTime);
        return null;
    }

    public Date getNextEndTime(Date afterTime) {
        for (Object obj : this.getPeriodList(afterTime)) {
            DateTime time = ((net.fortuna.ical4j.model.Period)obj).getEnd();
            if (!time.after(afterTime)) continue;
            return time;
        }
        logger.warn("could not determine next period end time: {} {}", (Object)this.getName(), (Object)afterTime);
        return null;
    }

    public Date getNextStartEndTime(Date afterTime) {
        for (Object obj : this.getPeriodList(afterTime)) {
            net.fortuna.ical4j.model.Period period = (net.fortuna.ical4j.model.Period)obj;
            if (period.getStart().after(afterTime)) {
                return period.getStart();
            }
            if (!period.getEnd().after(afterTime)) continue;
            return period.getEnd();
        }
        logger.warn("could not determine next period start/end time: {} {}", (Object)this.getName(), (Object)afterTime);
        return null;
    }

    public boolean isTimeIncluded(long timeStamp) {
        Date date = new Date(timeStamp);
        for (Object period : this.getPeriodList(date)) {
            if (((net.fortuna.ical4j.model.Period)period).getStart().after(date)) {
                return false;
            }
            if (!((net.fortuna.ical4j.model.Period)period).getEnd().after(date)) continue;
            return true;
        }
        return false;
    }

    static net.fortuna.ical4j.model.Period getFirstPeriod(PeriodList periods) {
        if (periods.size() < 1) {
            return null;
        }
        return (net.fortuna.ical4j.model.Period)periods.toArray()[0];
    }

    static net.fortuna.ical4j.model.Period getLastPeriod(PeriodList periods) {
        int length = periods.size() - 1;
        if (length < 0) {
            return null;
        }
        return (net.fortuna.ical4j.model.Period)periods.toArray()[length];
    }

    private void clearCache() {
        this.periodsCache = null;
        this.periodsCachePeriod = null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CalendarInstance)) {
            return false;
        }
        return this.compareTo((CalendarInstance)obj) == 0;
    }

    @Override
    public int compareTo(CalendarInstance that) {
        return this.name.compareTo(that.name);
    }

    public String toString() {
        return this.name;
    }
}

