/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.calendar;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.PersistMessage;
import com.beyondcron.messaging.proto.ProtoICalendar;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.CalendarException;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.TimeZones;
import org.apache.logging.log4j.Logger;

public class ICalendarData
implements Comparable<ICalendarData>,
Message<ICalendarData>,
PersistMessage<ICalendarData> {
    static final Logger logger = LogUtils.getLogger(ICalendarData.class);
    private static final String MESSAGE_TAG = "ics";
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.calendar.ICalendarData".hashCode();
    public static final String CONFIG_ROOT_DIRECTORY = "beyondcron.calendar.directory";
    public static final String DEFAULT_ROOT_DIRECTORY = File.separator;
    private static final String CALENDAR_NAME = "X-WR-CALNAME";
    private static final String CALENDAR_DESCRIPTION = "X-WR-CALDESC";
    static File rootDirectory = new File(System.getProperty("beyondcron.calendar.directory", DEFAULT_ROOT_DIRECTORY));
    public static Map<URI, ICalendarData> defaultCalendars;
    public static ICalendarData DAILY;
    public static ICalendarData WEEKDAY;
    public static ICalendarData WEEKEND;
    public static ICalendarData JANUARY;
    public static ICalendarData FEBRUARY;
    public static ICalendarData MARCH;
    public static ICalendarData APRIL;
    public static ICalendarData MAY;
    public static ICalendarData JUNE;
    public static ICalendarData JULY;
    public static ICalendarData AUGUST;
    public static ICalendarData SEPTEMBER;
    public static ICalendarData OCTOBER;
    public static ICalendarData NOVEMBER;
    public static ICalendarData DECEMBER;
    static final CalendarBuilder builder;
    private URI uri = null;
    private String name = "";
    private String description = "";
    private ByteString data = null;
    private long modified = -1L;
    private long refreshed = 0L;

    public ICalendarData() {
    }

    public ICalendarData(String name, String description, String definition) {
        try {
            this.uri = new URI("beyondcron:" + BlissUtils.CALENDAR_DIR.toString() + "/" + name);
        }
        catch (URISyntaxException e) {
            Localise.logFatal(logger, e, "Unexpected exception creating URI", new Object[0]);
            Program.exit(1);
        }
        this.name = name;
        this.description = description;
        this.data = ByteString.copyFromUtf8((String)definition);
        this.modified = System.currentTimeMillis();
        defaultCalendars.put(this.uri, this);
        this.update();
    }

    public ICalendarData(URI uri) throws CalendarException {
        this.uri = this.normaliseURI(uri);
        this.update();
    }

    private URI normaliseURI(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            Localise.logDebug(logger, "URI schema missing: %1$s", uri);
            throw new CalendarException("URI scheme missing: " + uri);
        }
        if ("file".equals(scheme)) {
            try {
                return new URI(scheme + ":" + new File(rootDirectory, uri.getPath()).getCanonicalPath().replace(File.separator, "/"));
            }
            catch (Exception e) {
                Localise.logError(logger, "Problem prepending root directory to calendar path", new Object[0]);
            }
        }
        return uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getLastModified() {
        return this.modified;
    }

    public long getLastRefreshed() {
        return this.refreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar getICalendar(TimeZone timeZone) {
        try {
            CalendarBuilder calendarBuilder = builder;
            synchronized (calendarBuilder) {
                TimeZones.setDefault((TimeZone)timeZone);
                return builder.build(this.data.newInput());
            }
        }
        catch (Exception e) {
            Localise.logError(logger, e, "Could not update calendar %1$s for %2$s", this.uri, timeZone);
            Localise.logDebug(logger, "Calendar %1$s data: %2$s", this.uri, this.data.toStringUtf8());
            throw new CalendarException(e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update() throws CalendarException {
        ByteString d;
        long lastModified;
        block20: {
            URLConnection connection;
            this.refreshed = System.currentTimeMillis();
            String scheme = this.uri.getScheme();
            if (scheme == null || scheme.equals("beyondcron")) {
                if (defaultCalendars.containsKey(this.uri)) return false;
                Localise.logError(logger, "Calendar %1$s does not exist", this.uri);
                throw new CalendarException("Calendar does not exist");
            }
            if (scheme.equals("file") && !new File(this.uri.getPath()).exists()) {
                Localise.logError(logger, "Calendar %1$s does not exist", this.uri);
                throw new CalendarException("Calendar does not exist");
            }
            try {
                connection = this.uri.toURL().openConnection();
                if (connection instanceof HttpURLConnection) {
                    connection.setConnectTimeout((int)((Period)Configs.get("beyondcron.icalendar.host.timeout")).getMilliseconds());
                }
            }
            catch (Exception e) {
                Localise.logError(logger, e, "Could not get calender %1$s", this.uri);
                throw new CalendarException(e.getMessage());
            }
            try {
                lastModified = connection.getLastModified();
                if (lastModified > 0L && lastModified <= this.modified) {
                    return false;
                }
            }
            catch (Exception e) {
                Localise.logError(logger, e, "Could not get calendar %1$s", this.uri);
                throw new CalendarException(e.getMessage());
            }
            InputStream in = null;
            try {
                in = connection.getInputStream();
                String host = this.uri.getHost();
                d = StringUtils.isNullOrEmpty(host) || !host.toLowerCase().endsWith("officeholidays.com") ? ByteString.readFrom((InputStream)in) : ByteString.copyFromUtf8((String)this.correctOfficeHolidaysData(in));
                if (d.size() < 1 && connection instanceof HttpURLConnection) {
                    HttpURLConnection conn = (HttpURLConnection)connection;
                    int i = conn.getResponseCode();
                    if (i == 302) throw new Exception(conn.getResponseMessage() + " " + connection.getHeaderField("Location"));
                    if (i == 301) {
                        throw new Exception(conn.getResponseMessage() + " " + connection.getHeaderField("Location"));
                    }
                }
                if (in == null) break block20;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new CalendarException(Localise.format("icalendar %1$s does not exist", this.uri));
                    catch (Exception e2) {
                        Localise.logDebug(logger, e2, "Could not update calendar %1$s", this.uri);
                        throw new CalendarException(e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        Localise.logError(logger, e3, "Could not close URL %1$s", this.uri);
                    }
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (IOException e) {
                Localise.logError(logger, e, "Could not close URL %1$s", this.uri);
            }
        }
        if (d.equals((Object)this.data)) {
            return false;
        }
        this.data = d;
        Localise.logDebug(logger, "Calendar %1$s updated", this.uri);
        this.modified = lastModified > 0L ? lastModified : this.refreshed;
        Calendar calendar = this.getICalendar(TimeZones.getUtcTimeZone());
        Property property = calendar.getProperty(CALENDAR_NAME);
        this.name = property != null ? property.getValue() : Localise.format("Unknown calendar");
        property = calendar.getProperty(CALENDAR_DESCRIPTION);
        this.description = property != null ? property.getValue() : "";
        return true;
    }

    private String correctOfficeHolidaysData(InputStream inStream) throws IOException {
        String line;
        StringBuilder data = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        while ((line = in.readLine()) != null && !line.equals("END:VEVENT")) {
            data.append(line).append("\n");
            if (!line.equals("BEGIN:VEVENT")) continue;
        }
        if (line != null) {
            while ((line = in.readLine()) != null) {
                data.append(line).append("\n");
            }
        }
        return data.toString();
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    @Override
    public Name getPersistName() {
        return ICalendarData.getPersistName(this.uri);
    }

    public static Name getPersistName(URI uri) {
        return Name.parse("/" + NetUtils.decode(uri.toString()).replaceAll("[:/?&]+", "+").replaceAll("[\\s]+", "_").replaceAll("\\.ics$", ""));
    }

    public ProtoICalendar.ICalendarData.Builder toProto() {
        ProtoICalendar.ICalendarData.Builder builder = ProtoICalendar.ICalendarData.newBuilder();
        builder.setName(this.name);
        if (!StringUtils.isNullOrEmpty(this.description)) {
            builder.setDescription(this.description);
        }
        builder.setUri(this.uri.toString());
        builder.setData(this.data);
        builder.setLastModified(this.modified);
        builder.setLastRefreshed(this.refreshed);
        return builder;
    }

    @Override
    public ICalendarData fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoICalendar.ICalendarData proto = ProtoICalendar.ICalendarData.parseFrom(data);
        this.name = proto.getName();
        this.description = proto.hasDescription() ? proto.getDescription() : "";
        this.uri = NetUtils.parseURI(proto.getUri());
        this.data = proto.getData();
        this.modified = proto.getLastModified();
        this.refreshed = proto.getLastRefreshed();
        return this;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICalendarData)) {
            return false;
        }
        return this.compareTo((ICalendarData)obj) == 0;
    }

    @Override
    public int compareTo(ICalendarData that) {
        return this.uri.compareTo(that.uri);
    }

    public String toString() {
        return this.uri.toString();
    }

    static {
        if (!FileUtils.isAbsolute(rootDirectory)) {
            logger.error("{} path is not absolute, using {} instead", (Object)rootDirectory.toString(), (Object)DEFAULT_ROOT_DIRECTORY);
            rootDirectory = new File(DEFAULT_ROOT_DIRECTORY);
        }
        defaultCalendars = new LinkedHashMap<URI, ICalendarData>();
        DAILY = new ICalendarData("Daily", "Monday to Sunday", "BEGIN:VCALENDAR\nX-WR-CALNAME:Daily\nX-WR-CALDESC:Monday to Sunday\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Daily event\nRRULE:FREQ=DAILY;INTERVAL=1\nEND:VEVENT\nEND:VCALENDAR");
        WEEKDAY = new ICalendarData("Weekday", "Monday to Friday", "BEGIN:VCALENDAR\nX-WR-CALNAME:Weekday\nX-WR-CALDESC:Monday to Friday\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekday event\nRRULE:FREQ=WEEKLY;INTERVAL=1;BYDAY=MO,TU,WE,TH,FR\nEND:VEVENT\nEND:VCALENDAR");
        WEEKEND = new ICalendarData("Weekend", "Saturday and Sunday", "BEGIN:VCALENDAR\nX-WR-CALNAME:Weekend\nX-WR-CALDESC:Saturday and Sunday\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=WEEKLY;INTERVAL=1;BYDAY=SA,SU\nEND:VEVENT\nEND:VCALENDAR");
        JANUARY = new ICalendarData("January", "Daily in January", "BEGIN:VCALENDAR\nX-WR-CALNAME:January\nX-WR-CALDESC:Daily in January\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=1\nEND:VEVENT\nEND:VCALENDAR");
        FEBRUARY = new ICalendarData("February", "Daily in February", "BEGIN:VCALENDAR\nX-WR-CALNAME:February\nX-WR-CALDESC:Daily in February\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=2\nEND:VEVENT\nEND:VCALENDAR");
        MARCH = new ICalendarData("March", "Daily in March", "BEGIN:VCALENDAR\nX-WR-CALNAME:March\nX-WR-CALDESC:Daily in March\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=3\nEND:VEVENT\nEND:VCALENDAR");
        APRIL = new ICalendarData("April", "Daily in April", "BEGIN:VCALENDAR\nX-WR-CALNAME:April\nX-WR-CALDESC:Daily in April\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR");
        MAY = new ICalendarData("May", "Daily in May", "BEGIN:VCALENDAR\nX-WR-CALNAME:May\nX-WR-CALDESC:Daily in May\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=5\nEND:VEVENT\nEND:VCALENDAR");
        JUNE = new ICalendarData("June", "Daily in June", "BEGIN:VCALENDAR\nX-WR-CALNAME:June\nX-WR-CALDESC:Daily in June\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=6\nEND:VEVENT\nEND:VCALENDAR");
        JULY = new ICalendarData("July", "Daily in July", "BEGIN:VCALENDAR\nX-WR-CALNAME:July\nX-WR-CALDESC:Daily in July\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=7\nEND:VEVENT\nEND:VCALENDAR");
        AUGUST = new ICalendarData("August", "Daily in August", "BEGIN:VCALENDAR\nX-WR-CALNAME:August\nX-WR-CALDESC:Daily in August\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=8\nEND:VEVENT\nEND:VCALENDAR");
        SEPTEMBER = new ICalendarData("September", "Daily in September", "BEGIN:VCALENDAR\nX-WR-CALNAME:September\nX-WR-CALDESC:Daily in September\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=9\nEND:VEVENT\nEND:VCALENDAR");
        OCTOBER = new ICalendarData("October", "Daily in October", "BEGIN:VCALENDAR\nX-WR-CALNAME:October\nX-WR-CALDESC:Daily in October\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=10\nEND:VEVENT\nEND:VCALENDAR");
        NOVEMBER = new ICalendarData("November", "Daily in November", "BEGIN:VCALENDAR\nX-WR-CALNAME:November\nX-WR-CALDESC:Daily in November\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=11\nEND:VEVENT\nEND:VCALENDAR");
        DECEMBER = new ICalendarData("December", "Daily in December", "BEGIN:VCALENDAR\nX-WR-CALNAME:December\nX-WR-CALDESC:Daily in December\nBEGIN:VEVENT\nDTSTART:20150101T000000\nDURATION:P1D\nSUMMARY:Weekend event\nRRULE:FREQ=DAILY;INTERVAL=1;BYMONTH=12\nEND:VEVENT\nEND:VCALENDAR");
        builder = new CalendarBuilder();
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
    }
}

