/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.config;

import com.beyondcron.core.BooleanUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.config.Config;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class BooleanConfig
extends Config<Boolean> {
    static final Logger logger = LogUtils.getLogger(BooleanConfig.class);
    public static final boolean DEFAULT_VALUE = false;

    public BooleanConfig() {
    }

    public BooleanConfig(String name, String description, boolean defaultValue, boolean secret, boolean startup, boolean hidden) {
        super(name, description, defaultValue, secret, startup, hidden);
    }

    public BooleanConfig set(String value, Config.Type type) throws IllegalArgumentException {
        this.setValue(BooleanUtils.valueOf(value), type);
        return this;
    }

    @Override
    public String validate(Boolean value) {
        return null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (((Boolean)this.defaultValue).booleanValue()) {
            json.put("default", this.defaultValue);
        }
        return json;
    }

    @Override
    public Config<Boolean> fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        this.defaultValue = json.optBoolean("default", false);
        return this;
    }

    @Override
    public ProtoConfig.Config.Builder toProto() {
        ProtoConfig.Config.Builder baseBuilder = super.toProto();
        ProtoConfig.ConfigBoolean.Builder builder = ProtoConfig.ConfigBoolean.newBuilder();
        if (this.value != null) {
            builder.setValue((Boolean)this.value);
        }
        if (((Boolean)this.defaultValue).booleanValue()) {
            builder.setDefaultValue((Boolean)this.defaultValue);
        }
        baseBuilder.setBooleanExt(builder);
        return baseBuilder;
    }

    @Override
    public BooleanConfig fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.ConfigBoolean proto = ProtoConfig.Config.parseFrom(data).getBooleanExt();
        super.fromProto(data);
        this.value = proto.hasValue() ? Boolean.valueOf(proto.getValue()) : null;
        this.defaultValue = proto.hasDefaultValue() ? proto.getDefaultValue() : false;
        return this;
    }

    @Override
    public BooleanConfig duplicate() {
        try {
            return new BooleanConfig().fromProto(this.toProto().build().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            Localise.logError(logger, "Unexpected exception duplicating config - %1$s", e.getMessage());
            return null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Annotation {
        public String description() default "";

        public boolean defaultValue() default false;

        public boolean secret() default false;

        public boolean startup() default false;

        public boolean hidden() default false;
    }
}

