/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.config;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Duplicatable;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.BooleanConfig;
import com.beyondcron.core.config.DoubleConfig;
import com.beyondcron.core.config.IntegerConfig;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Config<T>
implements Diff<Config<T>>,
Comparable<Config<T>>,
Duplicatable<Config<T>>,
Message<Config<T>>,
JSON<Config<T>> {
    static final Logger logger = LogUtils.getLogger(Config.class);
    private static final String MESSAGE_TAG = "config";
    public static final String JSON_NAME = "name";
    public static final String JSON_DESCRIPTION = "description";
    public static final String JSON_TYPE = "type";
    public static final String JSON_SECRET = "secret";
    public static final String JSON_STARTUP = "startup";
    public static final String JSON_HIDDEN = "hidden";
    public static final String JSON_VALUE = "value";
    public static final String JSON_DEFAULT = "default";
    public static final String HIDDEN = "********";
    protected String name;
    protected T value = null;
    protected T defaultValue;
    private String description;
    private Type type = Type.INTERNAL;
    private boolean secret;
    private boolean startup;
    private boolean hidden;

    protected Config() {
    }

    protected Config(String name, String description, T defaultValue, boolean secret, boolean startup, boolean hidden) {
        this.name = name;
        this.description = StringUtils.stripDuplicateSpaces(description);
        this.defaultValue = defaultValue;
        this.secret = secret;
        this.startup = startup;
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public Config<T> setName(String name) {
        this.name = name;
        return this;
    }

    public Name getPath() {
        return Config.getPath(this.name);
    }

    public static Name getPath(String name) {
        return Name.parse(BlissUtils.ACL_DIR_CONFIGURATION, name);
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public boolean hasDefault() {
        return !StringUtils.isNullOrEmpty(this.defaultValue);
    }

    public boolean isDefault() {
        return this.value == null;
    }

    public T getValue() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public Config<T> setValue(T value) throws IllegalArgumentException {
        return this.setValue(value, this.type);
    }

    public Config<T> setValue(T value, Type type) throws IllegalArgumentException {
        String error = this.validate(value);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.value = value;
        this.type = type;
        return this;
    }

    public Config<T> set(String value) throws IllegalArgumentException {
        return this.set(value, Type.INTERNAL);
    }

    public abstract Config<T> set(String var1, Type var2) throws IllegalArgumentException;

    public Config<T> unset() {
        this.value = null;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return !StringUtils.isNullOrEmpty(this.description);
    }

    public abstract String validate(T var1);

    public Type getType() {
        return this.type;
    }

    public Config<T> setType(Type type) {
        this.type = type;
        return this;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    protected static <T> T getConfigInitValue(String valueName) {
        boolean field;
        int i = valueName.lastIndexOf(".");
        if (i < 0) {
            Localise.logFatal(logger, "Init annotation does not contain a path - %1$s", valueName);
            Program.exit(1);
        }
        String className = valueName.substring(0, i);
        String member = valueName.substring(++i);
        Object value = null;
        boolean bl = field = !valueName.endsWith(")");
        if (!field && !valueName.endsWith("()")) {
            Localise.logFatal(logger, "Init methods with parameters are not supported %1$s", member);
            Program.exit(1);
        }
        Class<?> clazz = null;
        try {
            clazz = Configs.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Localise.logFatal(logger, e, "Could not load class %1$s for init value %2$s", className, valueName);
            Program.exit(1);
        }
        if (field) {
            try {
                value = clazz.getDeclaredField(member).get(null);
            }
            catch (Exception e) {
                Localise.logFatal(logger, e, "Could not read init value %1$s", valueName);
                Program.exit(1);
            }
        } else {
            member = member.replace("()", "");
            try {
                Method method = clazz.getMethod(member, new Class[0]);
                value = method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Localise.logFatal(logger, e, "Could not execute init method %1$s", valueName);
                Program.exit(1);
            }
        }
        return (T)value;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Config)) {
            return false;
        }
        return this.compareTo((Config)obj) == 0;
    }

    @Override
    public int compareTo(Config that) {
        return this.name.compareTo(that.name);
    }

    @Override
    public JSONObject diff(Config<T> that) {
        return this.diff(that, false);
    }

    public JSONObject diff(Config<T> that, boolean showSecrets) {
        JSONObject diffs = new JSONObject();
        if (!this.value.equals(that.value)) {
            if (!this.secret || showSecrets) {
                diffs.put(JSON_VALUE, JSON.array(this.value, that.value));
            } else {
                diffs.put(JSON_VALUE, JSON.array(HIDDEN, HIDDEN));
            }
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name);
        if (!StringUtils.isNullOrEmpty(this.description)) {
            json.put(JSON_DESCRIPTION, this.description);
        }
        if (this.type != Type.INTERNAL) {
            json.put(JSON_TYPE, this.type.toString());
        }
        if (this.secret) {
            json.put(JSON_SECRET, true);
        }
        if (this.startup) {
            json.put(JSON_STARTUP, true);
        }
        if (this.hidden) {
            json.put(JSON_HIDDEN, true);
        }
        if (this.value != null) {
            json.put(JSON_VALUE, this.value);
        }
        return json;
    }

    @Override
    public Config<T> fromJSON(JSONObject json) throws JSONException {
        this.name = json.getString(JSON_NAME);
        this.description = json.optString(JSON_DESCRIPTION);
        this.type = Type.valueOf(json.optString(JSON_TYPE, Type.INTERNAL.toString()).toUpperCase());
        this.secret = json.optBoolean(JSON_SECRET, false);
        this.startup = json.optBoolean(JSON_STARTUP, false);
        this.hidden = json.optBoolean(JSON_HIDDEN, false);
        this.value = json.opt(JSON_VALUE);
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoConfig.Config.Builder toProto() {
        ProtoConfig.Config.Builder builder = ProtoConfig.Config.newBuilder();
        builder.setName(this.name);
        if (!StringUtils.isNullOrEmpty(this.description)) {
            builder.setDescription(this.description);
        }
        if (this.type != Type.INTERNAL) {
            builder.setType(this.type.toProto());
        }
        if (this.secret) {
            builder.setSecret(true);
        }
        if (this.startup) {
            builder.setStartup(true);
        }
        if (this.hidden) {
            builder.setHidden(true);
        }
        return builder;
    }

    @Override
    public Config<T> fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.Config proto = ProtoConfig.Config.parseFrom(data);
        this.name = proto.getName();
        this.description = proto.hasDescription() ? proto.getDescription() : "";
        this.type = Type.fromProto(proto.getType());
        this.secret = proto.getSecret();
        this.startup = proto.getStartup();
        this.hidden = proto.getHidden();
        return this;
    }

    public static Config<?> parseFromProto(byte[] data) throws InvalidProtocolBufferException {
        Config config;
        ProtoConfig.Config proto = ProtoConfig.Config.parseFrom(data);
        if (proto.hasStringExt()) {
            config = new StringConfig();
        } else if (proto.hasIntegerExt()) {
            config = new IntegerConfig();
        } else if (proto.hasDoubleExt()) {
            config = new DoubleConfig();
        } else if (proto.hasBooleanExt()) {
            config = new BooleanConfig();
        } else if (proto.hasPeriodExt()) {
            config = new PeriodConfig();
        } else {
            Localise.logError(logger, "Unsupported configs received: %s", proto.getName());
            return null;
        }
        return ((Config)config).fromProto(data);
    }

    public static enum Type {
        EXTERNAL,
        INTERNAL,
        SYSTEM,
        USER;

        private static final EnumMap<Type, ProtoConfig.Config.Type> typeMap;

        public static Type fromProto(ProtoConfig.Config.Type type) {
            return typeMap.getA(type);
        }

        public ProtoConfig.Config.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoConfig.Config.Type>(Type.class, ProtoConfig.Config.Type.class);
        }
    }
}

