/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.config;

import com.beyondcron.core.JSON;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.google.protobuf.InvalidProtocolBufferException;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigProperty
implements Message<ConfigProperty>,
JSON<ConfigProperty> {
    public static final String MESSAGE_TAG = "config";
    private String name;
    private String value;

    public ConfigProperty() {
    }

    public ConfigProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("name", this.name);
        if (!StringUtils.isNullOrEmpty(this.value)) {
            json.put("value", this.value);
        }
        return json;
    }

    @Override
    public ConfigProperty fromJSON(JSONObject json) throws JSONException {
        this.name = json.getString("name");
        this.value = json.optString("value");
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoProperty.Property.Builder toProto() {
        ProtoProperty.Property.Builder builder = ProtoProperty.Property.newBuilder();
        builder.setName(this.name);
        if (!StringUtils.isNullOrEmpty(this.value)) {
            builder.setValue(this.value);
        }
        return builder;
    }

    @Override
    public ConfigProperty fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoProperty.Property proto = ProtoProperty.Property.parseFrom(data);
        this.name = proto.getName();
        this.value = proto.hasValue() ? proto.getValue() : "";
        return this;
    }
}

