/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.config;

import com.beyondcron.core.Localise;
import com.beyondcron.core.config.Config;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONException;
import org.json.JSONObject;

public class DoubleConfig
extends Config<Double> {
    public static final double DEFAULT_VALUE = 0.0;
    public static final String JSON_MIN_VALUE = "minValue";
    public static final String JSON_MAX_VALUE = "maxValue";
    private double minValue;
    private double maxValue;

    public DoubleConfig() {
    }

    public DoubleConfig(String name, String description, double defaultValue, double minValue, double maxValue, boolean secret, boolean startup, boolean hidden) {
        super(name, description, defaultValue, secret, startup, hidden);
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        } else {
            this.minValue = maxValue;
            this.maxValue = minValue;
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public DoubleConfig set(String value, Config.Type type) throws IllegalArgumentException {
        try {
            this.setValue(Double.valueOf(value), type);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return this;
    }

    @Override
    public String validate(Double value) {
        if (value < this.minValue) {
            return this.maxValue == Double.MAX_VALUE ? Localise.format("value must be >= %1$d", this.minValue) : Localise.format("value must be >= %1$d and <= %2$d", this.minValue, this.maxValue);
        }
        if (value > this.maxValue) {
            return this.minValue == Double.MIN_VALUE ? Localise.format("value must be <= %1$d", this.maxValue) : Localise.format("value must be >= %1$d and <= %2$d", this.minValue, this.maxValue);
        }
        return null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if ((Double)this.defaultValue != 0.0) {
            json.put("default", this.defaultValue);
        }
        if (this.minValue != Double.MIN_VALUE) {
            json.put(JSON_MIN_VALUE, this.minValue);
        }
        if (this.maxValue != Double.MAX_VALUE) {
            json.put(JSON_MAX_VALUE, this.maxValue);
        }
        return json;
    }

    @Override
    public DoubleConfig fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        this.defaultValue = json.optDouble("default", 0.0);
        this.minValue = json.optDouble(JSON_MIN_VALUE, Double.MIN_VALUE);
        this.maxValue = json.optDouble(JSON_MAX_VALUE, Double.MAX_VALUE);
        return this;
    }

    @Override
    public ProtoConfig.Config.Builder toProto() {
        ProtoConfig.Config.Builder baseBuilder = super.toProto();
        ProtoConfig.ConfigDouble.Builder builder = ProtoConfig.ConfigDouble.newBuilder();
        if (this.value != null) {
            builder.setValue((Double)this.value);
        }
        if ((Double)this.defaultValue != 0.0) {
            builder.setDefaultValue((Double)this.defaultValue);
        }
        if (this.minValue != Double.MIN_VALUE) {
            builder.setMinValue(this.minValue);
        }
        if (this.maxValue != Double.MAX_VALUE) {
            builder.setMaxValue(this.maxValue);
        }
        baseBuilder.setDoubleExt(builder);
        return baseBuilder;
    }

    @Override
    public DoubleConfig fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.ConfigDouble proto = ProtoConfig.Config.parseFrom(data).getDoubleExt();
        super.fromProto(data);
        this.value = proto.hasValue() ? Double.valueOf(proto.getValue()) : null;
        this.defaultValue = proto.hasDefaultValue() ? proto.getDefaultValue() : 0.0;
        this.minValue = proto.hasMinValue() ? proto.getMinValue() : Double.MIN_VALUE;
        this.maxValue = proto.hasMaxValue() ? proto.getMaxValue() : Double.MAX_VALUE;
        return this;
    }

    @Override
    public DoubleConfig duplicate() {
        try {
            return new DoubleConfig().fromProto(this.toProto().build().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            Localise.logError(logger, "Unexpected exception duplicating config - %1$s", e.getMessage());
            return null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Annotation {
        public String description() default "";

        public double defaultValue() default 0.0;

        public double minValue() default 4.9E-324;

        public double maxValue() default 1.7976931348623157E308;

        public boolean secret() default false;

        public boolean startup() default false;

        public boolean hidden() default false;
    }
}

