/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.config;

import com.beyondcron.core.Localise;
import com.beyondcron.core.config.Config;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONException;
import org.json.JSONObject;

public class IntegerConfig
extends Config<Integer> {
    public static final int DEFAULT_VALUE = 0;
    public static final String JSON_MIN_VALUE = "minValue";
    public static final String JSON_MAX_VALUE = "maxValue";
    private int minValue;
    private int maxValue;

    public IntegerConfig() {
    }

    public IntegerConfig(String name, String description, int defaultValue, int minValue, int maxValue, boolean secret, boolean startup, boolean hidden) {
        super(name, description, defaultValue, secret, startup, hidden);
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        } else {
            this.minValue = maxValue;
            this.maxValue = minValue;
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public IntegerConfig set(String value, Config.Type type) throws IllegalArgumentException {
        try {
            this.setValue(Integer.valueOf(value), type);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return this;
    }

    @Override
    public String validate(Integer value) {
        if (value < this.minValue) {
            return this.maxValue == Integer.MAX_VALUE ? Localise.format("value must be >= %1$d", this.minValue) : Localise.format("value must be >= %1$d and <= %2$d", this.minValue, this.maxValue);
        }
        if (value > this.maxValue) {
            return this.minValue == Integer.MIN_VALUE ? Localise.format("value must be <= %1$d", this.maxValue) : Localise.format("value must be >= %1$d and <= %2$d", this.minValue, this.maxValue);
        }
        return null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if ((Integer)this.defaultValue != 0) {
            json.put("default", this.defaultValue);
        }
        if (this.minValue != Integer.MIN_VALUE) {
            json.put(JSON_MIN_VALUE, this.minValue);
        }
        if (this.maxValue != Integer.MAX_VALUE) {
            json.put(JSON_MAX_VALUE, this.maxValue);
        }
        return json;
    }

    @Override
    public IntegerConfig fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        this.defaultValue = json.optInt("default", 0);
        this.minValue = json.optInt(JSON_MIN_VALUE, Integer.MIN_VALUE);
        this.maxValue = json.optInt(JSON_MAX_VALUE, Integer.MAX_VALUE);
        return this;
    }

    @Override
    public ProtoConfig.Config.Builder toProto() {
        ProtoConfig.Config.Builder baseBuilder = super.toProto();
        ProtoConfig.ConfigInteger.Builder builder = ProtoConfig.ConfigInteger.newBuilder();
        if (this.value != null) {
            builder.setValue((Integer)this.value);
        }
        if ((Integer)this.defaultValue != 0) {
            builder.setDefaultValue((Integer)this.defaultValue);
        }
        if (this.minValue != Integer.MIN_VALUE) {
            builder.setMinValue(this.minValue);
        }
        if (this.maxValue != Integer.MAX_VALUE) {
            builder.setMaxValue(this.maxValue);
        }
        baseBuilder.setIntegerExt(builder);
        return baseBuilder;
    }

    @Override
    public IntegerConfig fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.ConfigInteger proto = ProtoConfig.Config.parseFrom(data).getIntegerExt();
        super.fromProto(data);
        this.value = proto.hasValue() ? Integer.valueOf(proto.getValue()) : null;
        this.defaultValue = proto.hasDefaultValue() ? proto.getDefaultValue() : 0;
        this.minValue = proto.hasMinValue() ? proto.getMinValue() : Integer.MIN_VALUE;
        this.maxValue = proto.hasMaxValue() ? proto.getMaxValue() : Integer.MAX_VALUE;
        return this;
    }

    @Override
    public IntegerConfig duplicate() {
        try {
            return new IntegerConfig().fromProto(this.toProto().build().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            Localise.logError(logger, "Unexpected exception duplicating config - %1$s", e.getMessage());
            return null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Annotation {
        public String description() default "";

        public int defaultValue() default 0;

        public int minValue() default -2147483648;

        public int maxValue() default 0x7FFFFFFF;

        public boolean secret() default false;

        public boolean startup() default false;

        public boolean hidden() default false;
    }
}

