/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.config;

import com.beyondcron.core.Localise;
import com.beyondcron.core.Period;
import com.beyondcron.core.config.Config;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONException;
import org.json.JSONObject;

public class PeriodConfig
extends Config<Period> {
    public static final Period DEFAULT_VALUE = new Period("1 minute");
    public static final int DEFAULT_MIN_VALUE = 1;
    public static final int DEFAULT_MAX_VALUE = Integer.MAX_VALUE;
    public static final Period.Unit DEFAULT_MIN_UNIT = Period.Unit.SECOND;
    public static final Period.Unit DEFAULT_MAX_UNIT = Period.Unit.YEAR;
    public static final String JSON_MIN_VALUE = "minValue";
    public static final String JSON_MAX_VALUE = "maxValue";
    private int minValue;
    private int maxValue;
    private Period.Unit minUnit;
    private Period.Unit maxUnit;

    public PeriodConfig() {
    }

    public PeriodConfig(String name, String description, Period defaultValue, int minValue, int maxValue, Period.Unit minUnit, Period.Unit maxUnit, boolean secret, boolean startup, boolean hidden) {
        super(name, description, defaultValue != null ? defaultValue : DEFAULT_VALUE, secret, startup, hidden);
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (minUnit.ordinal() < maxUnit.ordinal()) {
            this.minUnit = minUnit;
            this.maxUnit = maxUnit;
        } else {
            this.minUnit = maxUnit;
            this.maxUnit = minUnit;
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public Period.Unit getMinUnit() {
        return this.minUnit;
    }

    public Period.Unit getMaxUnit() {
        return this.maxUnit;
    }

    public PeriodConfig set(String value, Config.Type type) throws IllegalArgumentException {
        this.setValue(new Period(value), type);
        return this;
    }

    @Override
    public String validate(Period value) {
        Period.Unit valueUnit = value.getUnit();
        Period minPeriod = new Period(this.minValue, this.minUnit);
        Period maxPeriod = new Period(this.maxValue, this.maxUnit);
        long i = value.getMilliseconds();
        if (valueUnit.ordinal() < minPeriod.getUnit().ordinal() || i < minPeriod.getMilliseconds()) {
            return this.maxValue == Integer.MAX_VALUE && this.maxUnit == DEFAULT_MAX_UNIT ? Localise.format("period must be >= %1$s", minPeriod.toString(true)) : Localise.format("period must be >= %1$s and <= %2$s", minPeriod.toString(true), maxPeriod.toString(true));
        }
        if (valueUnit.ordinal() > maxPeriod.getUnit().ordinal() || i > maxPeriod.getMilliseconds() && maxPeriod.getMilliseconds() > 0L) {
            System.out.println(maxPeriod.getMilliseconds());
            return this.minValue == 1 && this.minUnit == DEFAULT_MIN_UNIT ? Localise.format("period unit must be <= %1$s", maxPeriod.toString(true)) : Localise.format("period unit must be >= %1$s and <= %2$s", minPeriod.toString(true), maxPeriod.toString(true));
        }
        return null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (!((Period)this.defaultValue).equals(DEFAULT_VALUE)) {
            json.put("default", ((Period)this.defaultValue).toString());
        }
        if (this.minValue != 1 && this.minUnit != DEFAULT_MIN_UNIT) {
            json.put(JSON_MIN_VALUE, new Period(this.minValue, this.minUnit).toString());
        }
        if (this.maxValue != Integer.MAX_VALUE && this.maxUnit != DEFAULT_MAX_UNIT) {
            json.put(JSON_MAX_VALUE, new Period(this.maxValue, this.maxUnit).toString());
        }
        return json;
    }

    @Override
    public Config<Period> fromJSON(JSONObject json) throws JSONException {
        Period period;
        super.fromJSON(json);
        Object object = this.defaultValue = json.has("default") ? this.parseJSONPeriod("default", json.getString("default")) : DEFAULT_VALUE;
        if (json.has(JSON_MIN_VALUE)) {
            period = this.parseJSONPeriod(JSON_MIN_VALUE, json.getString(JSON_MIN_VALUE));
            this.minValue = period.getValue();
            this.minUnit = period.getUnit();
        } else {
            this.minValue = 1;
            this.minUnit = DEFAULT_MIN_UNIT;
        }
        if (json.has(JSON_MAX_VALUE)) {
            period = this.parseJSONPeriod(JSON_MAX_VALUE, json.getString(JSON_MAX_VALUE));
            this.maxValue = period.getValue();
            this.maxUnit = period.getUnit();
        } else {
            this.maxValue = Integer.MAX_VALUE;
            this.maxUnit = DEFAULT_MAX_UNIT;
        }
        return this;
    }

    private Period parseJSONPeriod(String name, String value) throws JSONException {
        try {
            return new Period(value);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", name, value, e.getMessage()));
        }
    }

    @Override
    public ProtoConfig.Config.Builder toProto() {
        ProtoConfig.Config.Builder baseBuilder = super.toProto();
        ProtoConfig.ConfigPeriod.Builder builder = ProtoConfig.ConfigPeriod.newBuilder();
        if (this.value != null) {
            builder.setValue(((Period)this.value).toProto());
        }
        if (!((Period)this.defaultValue).equals(DEFAULT_VALUE)) {
            builder.setDefaultValue(((Period)this.defaultValue).toProto());
        }
        if (this.minValue != 1) {
            builder.setMinValue(this.minValue);
        }
        if (this.maxValue != Integer.MAX_VALUE) {
            builder.setMaxValue(this.maxValue);
        }
        if (this.minUnit != DEFAULT_MIN_UNIT) {
            builder.setMinUnit(this.minUnit.toProto());
        }
        if (this.maxUnit != DEFAULT_MAX_UNIT) {
            builder.setMaxUnit(this.maxUnit.toProto());
        }
        baseBuilder.setPeriodExt(builder);
        return baseBuilder;
    }

    @Override
    public PeriodConfig fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.ConfigPeriod proto = ProtoConfig.Config.parseFrom(data).getPeriodExt();
        super.fromProto(data);
        this.value = proto.hasValue() ? new Period().fromProto(proto.getValue().toByteArray()) : null;
        this.defaultValue = proto.hasDefaultValue() ? new Period().fromProto(proto.getDefaultValue().toByteArray()) : DEFAULT_VALUE;
        this.minValue = proto.hasMinValue() ? proto.getMinValue() : 1;
        this.maxValue = proto.hasMaxValue() ? proto.getMaxValue() : Integer.MAX_VALUE;
        this.minUnit = proto.hasMinUnit() ? Period.Unit.fromProto(proto.getMinUnit()) : DEFAULT_MIN_UNIT;
        this.maxUnit = proto.hasMaxUnit() ? Period.Unit.fromProto(proto.getMaxUnit()) : DEFAULT_MAX_UNIT;
        return this;
    }

    @Override
    public PeriodConfig duplicate() {
        try {
            return new PeriodConfig().fromProto(this.toProto().build().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            Localise.logError(logger, "Unexpected exception duplicating config - %1$s", e.getMessage());
            return null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Annotation {
        public String description() default "";

        public String defaultValue() default "1 minute";

        public int minValue() default 1;

        public int maxValue() default 0x7FFFFFFF;

        public Period.Unit minUnit() default Period.Unit.SECOND;

        public Period.Unit maxUnit() default Period.Unit.YEAR;

        public boolean secret() default false;

        public boolean startup() default false;

        public boolean hidden() default false;
    }
}

