/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.JobExecute;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public abstract class AgentJob
extends Job {
    static final Logger logger = LogUtils.getLogger(AgentJob.class);
    private static boolean hazelcastInited = false;
    private static IMap<String, Connection> agentMap;
    private static IMap<Name, String> jobAgentMap;
    private static IQueue<JobExecute> sshCommandQueue;
    private static final Map<String, IQueue<JobExecute>> agentQueueMap;

    public AgentJob() {
    }

    public AgentJob(Job job) {
        super(job);
    }

    public AgentJob(Name name) {
        super(name);
    }

    private boolean initHazelcast() {
        if (hazelcast != null) {
            jobAgentMap = Hazelcast.getJobAgentMap(hazelcast);
            agentMap = Hazelcast.getAgentMap(hazelcast);
            sshCommandQueue = Hazelcast.getAgentSshCommandQueue(hazelcast);
            hazelcastInited = true;
        }
        return hazelcastInited;
    }

    public abstract String getHostName();

    @Override
    public void execute(Job.Action action, long startTimestamp, Trigger trigger, Status triggerStatus) {
        Name name = this.getName();
        if (!this.isAction(action)) {
            this.setStatus(new Status(name, Status.Result.ERROR).setMessage(Localise.format("Action %1$s not supported by %2$s", new Object[]{action, name})));
            return;
        }
        if (!hazelcastInited && !this.initHazelcast()) {
            this.setStatus(new Status(name, Status.Result.EXCEPTION).setMessage(Localise.format("Hazelcast not configured")));
            return;
        }
        IQueue<JobExecute> commandQueue = null;
        if (action != Job.Action.START) {
            commandQueue = this.getAgentCommandQueue(name);
        }
        if (commandQueue == null) {
            commandQueue = this.getAgentCommandQueue(this.getHostName().toLowerCase());
        }
        if (commandQueue != null) {
            commandQueue.add((Object)new JobExecute(this, action, startTimestamp, trigger, triggerStatus));
        }
    }

    private IQueue<JobExecute> getAgentCommandQueue(String hostName) {
        IQueue<JobExecute> queue = null;
        Connection connection = (Connection)agentMap.get((Object)hostName);
        if (connection != null && connection.isConnected()) {
            queue = Hazelcast.getAgentCommandQueue(hazelcast, hostName);
        }
        if (queue == null) {
            queue = sshCommandQueue;
        }
        if (queue != null && logger.isDebugEnabled()) {
            Localise.logWarn(logger, "Agent command queue - %s", queue.getName());
        }
        return queue;
    }

    private IQueue<JobExecute> getAgentCommandQueue(Name name) {
        String agentName = (String)jobAgentMap.get((Object)name);
        if (agentName == null) {
            return null;
        }
        Connection connection = (Connection)agentMap.get((Object)agentName);
        if (connection == null || !connection.isConnected()) {
            return null;
        }
        IQueue<JobExecute> queue = agentQueueMap.get(agentName);
        if (queue == null) {
            queue = Hazelcast.getAgentCommandQueue(hazelcast, agentName);
            agentQueueMap.put(agentName, queue);
        }
        return queue;
    }

    static {
        agentQueueMap = new HashMap<String, IQueue<JobExecute>>();
    }
}

