/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.ArrayUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Property;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.core.schedule.RepeatSchedule;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.fortuna.ical4j.model.CalendarException;
import org.apache.logging.log4j.Logger;

public class CalendarUpdateJob
extends Job {
    static final Logger logger = LogUtils.getLogger(CalendarUpdateJob.class);
    public static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.job.CalendarUpdateJob".hashCode();
    private static final List<Property.Type> propertyTypes = ArrayUtils.asList(Property.Type.VARIABLE);
    public static final Name NAME = Name.parse("/admin/updaters/calendar");
    public static final String DESCRIPTION = "iCalendar calendar updater";
    private static Future task = null;

    public CalendarUpdateJob() {
        super(NAME);
        this.setDescription(DESCRIPTION);
        this.addAction(Job.Action.START);
        this.addAction(Job.Action.KILL);
        this.addSchedule(new RepeatSchedule((Period)Configs.get("beyondcron.calendar.update")));
    }

    @Override
    public Job.Type getType() {
        return Job.Type.CALENDAR_UPDATE;
    }

    @Override
    public Property.Type getDefaultPropertyType() {
        return Property.Type.DEFAULT;
    }

    @Override
    public List<Property.Type> getPropertyTypes() {
        return propertyTypes;
    }

    @Override
    public boolean isEchoJob() {
        return false;
    }

    @Override
    public synchronized void execute(Job.Action action, long startTimestamp, Trigger trigger, Status triggerStatus) {
        Name name = this.getName();
        if (action == Job.Action.START) {
            if (task != null) {
                this.setStatus(new Status(name, Status.Result.ERROR).setMessage(Localise.format("Job %s already running", name)));
            }
            task = ThreadUtils.submit(() -> {
                this.setStatus(new Status(name, Status.State.RUNNING));
                IExecutorService executor = hazelcast.getExecutorService("CalendarUpdateJob");
                CalendarUpdateException exception = new CalendarUpdateException();
                int updated = 0;
                for (Future updater : executor.submitToAllMembers((Callable)new ICalendarUpdater()).values()) {
                    try {
                        updated += ((Integer)updater.get()).intValue();
                    }
                    catch (ExecutionException e) {
                        exception.add(e);
                    }
                    catch (Exception e) {
                        Localise.logError(logger, "Unexpected exception updating icalendars - %s", e.getMessage());
                        exception.add(e);
                    }
                }
                Localise.logDebug(logger, "Updated %d icalendars", updated);
                if (exception.isEmpty()) {
                    this.setStatus(new Status(name, Status.Result.SUCCESS).setExitValue(0));
                } else {
                    this.setStatus(new Status(name, exception));
                }
                task = null;
            });
        } else if (action == Job.Action.KILL) {
            if (task != null) {
                if (task.cancel(true)) {
                    task = null;
                    this.setStatus(new Status(name, Status.Result.KILLED));
                } else {
                    Localise.logError(logger, "Could not interrupt %s", name);
                }
            } else {
                this.setStatus(new Status(name, Status.Result.ERROR).setMessage(Localise.format("Job %s is not running", name)));
            }
        } else {
            Localise.logError(logger, "Unsupported action %s", new Object[]{action});
        }
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    @Override
    public ProtoJob.Job.Builder toProto() {
        return this.toProto(false);
    }

    @Override
    public ProtoJob.Job.Builder toProto(boolean summary) {
        return super.toProto(summary);
    }

    @Override
    public CalendarUpdateJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        super.fromProto(data);
        return this;
    }

    public static class CalendarUpdateException
    extends RuntimeException {
        private List<String> messages = new ArrayList<String>();

        public void add(URI uri, Exception e) {
            this.messages.add(uri.toString() + " - " + e.getMessage());
        }

        public void add(Exception e) {
            this.messages.add(e.getMessage());
        }

        public boolean isEmpty() {
            return this.messages.isEmpty();
        }

        @Override
        public String getMessage() {
            return StringUtils.join("\n", this.messages);
        }
    }

    private static class ICalendarUpdater
    implements Callable<Integer>,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;

        private ICalendarUpdater() {
        }

        @Override
        public Integer call() {
            CalendarUpdateException exception = new CalendarUpdateException();
            IMap<URI, ICalendarData> icalendars = Hazelcast.getICalendarMap(this.hazelcast);
            int updated = 0;
            for (URI uri : icalendars.localKeySet()) {
                ICalendarData calendar = (ICalendarData)icalendars.get((Object)uri);
                try {
                    if (calendar.update()) {
                        Localise.logDebug(logger, "Updated icalendar %s", uri);
                        ++updated;
                    }
                    icalendars.put((Object)uri, (Object)calendar);
                }
                catch (CalendarException e) {
                    Localise.logError(logger, (Exception)((Object)e), "Could not update %s", uri);
                    exception.add(uri, (Exception)((Object)e));
                }
            }
            if (!exception.isEmpty()) {
                throw exception;
            }
            return updated;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }
}

