/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Duplicatable;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.MessageSerializer;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Command
implements Duplicatable<Command>,
Message<Command> {
    private static final String MESSAGE_TAG = "command";
    public static final String BASH = (String)Configs.get("beyondcron.command.bash");
    private Job.Action action;
    private String command = null;
    private List<String> input = new ArrayList<String>();

    public Command() {
    }

    public Command(Job.Action action) {
        this(action, "");
    }

    public Command(String command) {
        this(Job.Action.START, command);
    }

    public Command(Job.Action action, String command) {
        this.action = action;
        this.command = command;
    }

    public Job.Action getAction() {
        return this.action;
    }

    public String getCommand() {
        return this.command;
    }

    public Command setCommand(String command) {
        this.command = command;
        return this;
    }

    public List<String> getInput() {
        return this.input;
    }

    public boolean hasInput() {
        return !this.input.isEmpty();
    }

    public Command clearInput() {
        this.input.clear();
        return this;
    }

    public Command setInput(List<String> lines) {
        return this.clearInput().addInput(lines);
    }

    public Command setInput(String ... lines) {
        return this.clearInput().addInput(lines);
    }

    public Command addInput(String ... lines) {
        if (lines.length == 1 && lines[0].isEmpty()) {
            return this;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, lines);
        return this.addInput(list);
    }

    public Command addInput(List<String> lines) {
        for (String line : lines) {
            Collections.addAll(this.input, line.split("\\n"));
        }
        return this;
    }

    public Command toScript() {
        if (!this.input.isEmpty()) {
            throw new IllegalStateException(Localise.format("Command already has input"));
        }
        this.input.add(this.command);
        this.command = BASH;
        return this;
    }

    public void validate() throws IllegalArgumentException {
        Command.validate(this.command);
    }

    public static void validate(String command) throws IllegalArgumentException {
        if (command == null) {
            return;
        }
        if (command.contains("|")) {
            throw new IllegalArgumentException(Localise.format("Shell pipes are not supported."));
        }
        if (command.contains("<") || command.contains(">")) {
            throw new IllegalArgumentException(Localise.format("Shell redirects are not supported."));
        }
        if (command.contains(";") || command.contains("&&") || command.contains("||")) {
            throw new IllegalArgumentException(Localise.format("Shell command sequences is not supported."));
        }
        if (command.contains("`")) {
            throw new IllegalArgumentException(Localise.format("Shell command substitution is not supported."));
        }
        if (command.contains("$")) {
            throw new IllegalArgumentException(Localise.format("Shell variable substitution is not supported."));
        }
        if (command.trim().endsWith("&")) {
            throw new IllegalArgumentException(Localise.format("Executing commands in the background is not supported."));
        }
        if (command.contains("*") || command.contains("?") || command.contains("[") || command.contains("]")) {
            throw new IllegalArgumentException(Localise.format("Shell globbing in not supported"));
        }
    }

    public String toString() {
        return String.format("%s: %s", StringUtils.capitalise((Object)this.action), this.command);
    }

    public static JSONArray diffCommand(Command before, Command after) {
        return Diff.diff(before != null ? before.getCommand() : null, after != null ? after.getCommand() : null);
    }

    public static JSONArray diffInput(Command before, Command after) {
        JSONArray diff = new JSONArray();
        if (before != null) {
            if (after != null) {
                if (!before.input.equals(after.input)) {
                    diff.put(JSON.array(before.input));
                    diff.put(JSON.array(after.input));
                }
            } else {
                diff.put(JSON.array(before.input));
                diff.put(JSONObject.NULL);
            }
        } else if (after != null) {
            diff.put(JSONObject.NULL);
            diff.put(JSON.array(after.input));
        }
        return diff;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.ShellCommand.Builder toProto() {
        ProtoJob.ShellCommand.Builder builder = ProtoJob.ShellCommand.newBuilder();
        if (this.action != Job.Action.START) {
            builder.setAction(this.action.toProto());
        }
        if (!StringUtils.isNullOrEmpty(this.command)) {
            builder.setCommand(this.command);
        }
        builder.addAllInput(this.input);
        return builder;
    }

    @Override
    public Command fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.ShellCommand proto = ProtoJob.ShellCommand.parseFrom(data);
        this.action = Job.Action.fromProto(proto.getAction());
        this.command = proto.hasCommand() ? proto.getCommand() : "";
        this.input.clear();
        this.input.addAll((Collection<String>)proto.getInputList());
        return this;
    }

    @Override
    public Command duplicate() {
        return (Command)new MessageSerializer().duplicate(this);
    }
}

