/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.ArrayUtils;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.MailUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.MessageJob;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class MailJob
extends MessageJob {
    static final Logger logger = LogUtils.getLogger(MailJob.class);
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.job.MailJob".hashCode();
    private static final List<Property.Type> propertyTypes = ArrayUtils.asList(Property.Type.VARIABLE);
    public static String DEFAULT_SUBJECT;
    public static String DEFAULT_MESSAGE;

    public MailJob() {
    }

    public MailJob(Job job) {
        super(job);
        if (job instanceof MailJob) {
            MailJob j = (MailJob)job;
            this.recipient = j.getRecipient();
            this.subject = j.getSubject();
        }
    }

    public MailJob(Name name) {
        super(name);
    }

    public MailJob(Name name, String recipient, String subject, String message) {
        super(name, recipient, subject, message);
    }

    @Override
    public String canEnableReason() {
        if (StringUtils.isNullOrEmpty(this.recipient)) {
            return Localise.format("Job has no recipient");
        }
        if (!MailUtils.isValidAddress(this.recipient)) {
            return Localise.format("Invalid recipient");
        }
        if (StringUtils.isNullOrEmpty(this.subject)) {
            return Localise.format("Job has no subject");
        }
        return super.canEnableReason();
    }

    @Override
    public Job.Type getType() {
        return Job.Type.MAIL;
    }

    @Override
    public Property.Type getDefaultPropertyType() {
        return Property.Type.VARIABLE;
    }

    @Override
    public List<Property.Type> getPropertyTypes() {
        return propertyTypes;
    }

    @Override
    public boolean isEchoJob() {
        return this.recipient != null && this.recipient.toLowerCase().endsWith("@example.com");
    }

    @Override
    public String getSubject() {
        return !StringUtils.isNullOrEmpty(this.subject) ? this.subject : Localise.format(DEFAULT_SUBJECT);
    }

    @Override
    public String getMessage() {
        return !StringUtils.isNullOrEmpty(this.message) ? this.message : Localise.format(DEFAULT_MESSAGE);
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    static {
        String resourceName = "";
        try {
            resourceName = "templates/MailJobSubject.txt";
            DEFAULT_SUBJECT = IOUtils.readResource(resourceName);
        }
        catch (IOException e) {
            Localise.logWarn(logger, "Could not load %1$s, using default - %2$s", resourceName, e.getMessage());
            DEFAULT_SUBJECT = "BeyondCron job {{ trigger.name }} {{ trigger.result }}";
        }
        try {
            resourceName = "templates/MailJobMessage.txt";
            DEFAULT_MESSAGE = IOUtils.readResource(resourceName);
        }
        catch (IOException e) {
            Localise.logWarn(logger, "Could not load %1$s, using default - %2$s", resourceName, e.getMessage());
            DEFAULT_MESSAGE = "Job: {{ trigger.name }}\nResult: {{ trigger.result }}\nTime: {{ trigger.time }}\nValue: {{ trigger.value }}\nMessage: {{ trigger.message }}";
        }
    }
}

