/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Name;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class QueuedJob
implements Message<QueuedJob> {
    public static final String MESSAGE_TAG = "queuedJob";
    private Name name;
    private long timestamp = System.currentTimeMillis();
    private Trigger trigger;
    private Status triggerStatus;

    public QueuedJob() {
    }

    public QueuedJob(Name name, Trigger trigger, Status triggerStatus, long timestamp) {
        this.name = name;
        this.trigger = trigger;
        this.triggerStatus = triggerStatus;
        this.timestamp = timestamp;
    }

    public Name getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Status getTriggerStatus() {
        return this.triggerStatus;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.QueuedJob.Builder toProto() {
        ProtoJob.QueuedJob.Builder builder = ProtoJob.QueuedJob.newBuilder();
        builder.setName(this.name.toProto());
        builder.setTimestamp(this.timestamp);
        builder.setTrigger(this.trigger.toProto());
        builder.setTriggerStatus(this.triggerStatus.toProto());
        return builder;
    }

    @Override
    public QueuedJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.QueuedJob proto = ProtoJob.QueuedJob.parseFrom(data);
        this.name = new Name(proto.getName());
        this.timestamp = proto.getTimestamp();
        this.trigger = new Trigger().fromProto(proto.getTrigger().toByteArray());
        this.triggerStatus = new Status().fromProto(proto.getTriggerStatus().toByteArray());
        return this;
    }
}

