/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Service;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Status;
import com.hazelcast.core.HazelcastInstance;
import java.util.List;

public abstract class StatusService
extends Service {
    public static long COUNT_LIMIT = 1000L;

    public static StatusService getService(HazelcastInstance hazelcast) throws ServiceException {
        StatusService service = null;
        String serviceName = (String)Configs.get("beyondcron.status.service");
        String className = Service.getClassName(serviceName, Service.Type.STATUS);
        if (!StringUtils.isNullOrEmpty(className)) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new ServiceException(Localise.format("Status service class does not exist - %s", className));
            }
            catch (ClassCastException e) {
                throw new ServiceException(Localise.format("class does not implement StatusService - %s", className));
            }
            try {
                service = (StatusService)clazz.newInstance();
                Configs.addConfigs(clazz);
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format("could not load status service %s - %s", className, e.getMessage()), e);
            }
            service.setHazelcast(hazelcast);
            service.connect();
        }
        return service;
    }

    protected StatusService(String name) {
        super(Service.Type.STATUS, name, true);
    }

    public abstract Status getStatus(Name var1, long var2, boolean var4);

    public abstract List<Status> getStatusesRange(Name var1, long var2, long var4);

    public abstract List<Status> getStatusesCount(Name var1, long var2, long var4);

    public abstract List<Status> getStatuses();

    public abstract void saveStatus(Status var1);

    public abstract int removeStatuses(long var1);

    public abstract int removeStatuses(Name var1, long var2);
}

