/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.FileUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class VariableFormatter {
    static final Logger logger = LogUtils.getLogger(VariableFormatter.class);
    private static final Pattern offsetPattern = Pattern.compile("^([-+])(\\d+)([smhdMy])(\\s*)");
    private static final Pattern randomPattern = Pattern.compile("(\\d+)(\\s+(\\d+))?");
    public static final Pattern variablePattern = Pattern.compile("\\{\\{\\s*(\\S+?)(\\s+(.*?))?\\s*\\}\\}");
    private static final Set<String> runtimeVariables = new HashSet<String>();
    public static final String FORMAT_EPOCH = "epoch";
    private static final int maxDepth = 10;
    private Job job = null;
    private Trigger trigger = null;
    private Status triggerStatus = null;
    private TimeZone timeZone;
    private long time;
    private Map<String, Property> properties = new HashMap<String, Property>();

    public <T extends Property> VariableFormatter(Map<String, T> properties, TimeZone timeZone, long time) {
        this.properties.putAll(properties);
        this.timeZone = timeZone;
        this.time = time;
    }

    public VariableFormatter(Job job) {
        this(job, null, null, System.currentTimeMillis());
    }

    public VariableFormatter(Job job, Trigger trigger, Status triggerStatus, long time) {
        this.job = job;
        this.trigger = trigger;
        this.triggerStatus = triggerStatus;
        this.timeZone = job.getTimeZone();
        this.time = time;
        for (Property property : job.getProperties()) {
            this.properties.put(property.getName(), property);
        }
    }

    public static boolean containsVariable(String value) {
        return variablePattern.matcher(value).find();
    }

    public long getTime() {
        return this.time;
    }

    public String expand(String format) {
        return this.expand(format, 0);
    }

    private String expand(String format, int depth) {
        if (StringUtils.isNullOrEmpty(format)) {
            return format;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        Matcher m = variablePattern.matcher(format);
        block32: while (m.find(start)) {
            Property property;
            sb.append(format, start, m.start());
            start = m.end();
            String name = m.group(1);
            String options = m.group(3);
            if (options != null && options.isEmpty()) {
                options = null;
            }
            if ((property = this.properties.get(name)) != null && options == null) {
                if (depth < 10) {
                    sb.append(this.expand(property.getValue(), depth + 1));
                    continue;
                }
                sb.append(property.getValue());
                continue;
            }
            switch (name) {
                case "dir.tmp": {
                    sb.append(FileUtils.temporaryDirectory);
                    break;
                }
                case "job.description": {
                    if (this.job == null) continue block32;
                    sb.append(this.job.getDescription());
                    break;
                }
                case "job.host": {
                    if (this.job == null || !(this.job instanceof CommandJob)) continue block32;
                    sb.append(((CommandJob)this.job).getHostName());
                    break;
                }
                case "job.name": {
                    if (this.job == null) continue block32;
                    sb.append(this.formatName(this.job.getName(), options));
                    break;
                }
                case "job.user": {
                    if (this.job == null || !(this.job instanceof CommandJob)) continue block32;
                    sb.append(((CommandJob)this.job).getUserName());
                    break;
                }
                case "random": {
                    sb.append(this.formatRandom(options));
                    break;
                }
                case "trigger.message": {
                    String s = this.triggerStatus != null ? this.triggerStatus.getMessage() : null;
                    if (s == null) continue block32;
                    sb.append(s);
                    break;
                }
                case "trigger.name": {
                    if (this.trigger == null) continue block32;
                    if (this.trigger.getType() == Trigger.Type.JOB) {
                        sb.append(this.formatName(this.trigger.getJobName(), options));
                        break;
                    }
                    sb.append(this.trigger.getText());
                    break;
                }
                case "trigger.output": {
                    if (this.triggerStatus == null) continue block32;
                    sb.append(this.formatTriggerOutput(this.triggerStatus.getOutput(), options));
                    break;
                }
                case "trigger.result": {
                    if (this.triggerStatus == null) continue block32;
                    sb.append(this.triggerStatus.getResult().getLabel());
                    break;
                }
                case "trigger.value": {
                    if (this.triggerStatus == null) continue block32;
                    sb.append(this.triggerStatus.getExitValue());
                    break;
                }
                case "trigger.time": {
                    if (this.triggerStatus == null) continue block32;
                    sb.append(this.formatTimestamp(this.triggerStatus.getTimestamp(), this.timeZone, options != null ? options : TimeUtils.dateTimeFormat, TimeUtils.dateTimeFormat, false));
                    break;
                }
                case "trigger.time.next": {
                    long l;
                    if (this.triggerStatus == null || (l = this.triggerStatus.getNextExecution()) < 0L) continue block32;
                    sb.append(this.formatTimestamp(l, this.timeZone, options != null ? options : TimeUtils.dateTimeFormat, TimeUtils.dateTimeFormat, false));
                    break;
                }
                case "time": {
                    sb.append(this.formatTimestamp(this.time, this.timeZone, options != null ? options : TimeUtils.dateTimeFormat, TimeUtils.dateTimeFormat, true));
                    break;
                }
                default: {
                    Localise.logWarn(logger, "Unsupported variable - %1$s", name);
                }
            }
        }
        sb.append(format.substring(start));
        return sb.toString();
    }

    public static String expand(String format, Map<String, String> variables) {
        if (StringUtils.isNullOrEmpty(format)) {
            return format;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        Matcher m = variablePattern.matcher(format);
        while (m.find(start)) {
            String value;
            sb.append(format, start, m.start());
            start = m.end();
            String name = m.group(1);
            String string = value = !runtimeVariables.contains(name) ? variables.get(name) : null;
            if (value != null) {
                sb.append(value);
                continue;
            }
            sb.append(m.group(0));
        }
        sb.append(format.substring(start));
        return sb.toString();
    }

    public static boolean isValid(String format, Map<String, String> variables) {
        int start = 0;
        Matcher m = variablePattern.matcher(format);
        while (m.find(start)) {
            start = m.end();
            String name = m.group(1);
            if (runtimeVariables.contains(name) || variables.containsKey(name)) continue;
            return false;
        }
        return true;
    }

    private String formatName(Name name, String options) {
        if (name == null) {
            return "";
        }
        if (options == null) {
            return name.toString();
        }
        List<String> opts = Arrays.asList(options.toLowerCase().split("\\s+"));
        return VariableFormatter.formatName(name, opts.contains("short"), opts.contains("encode"));
    }

    public static String formatName(Name name, boolean nameOnly, boolean encode) {
        String value;
        String string = value = nameOnly ? name.getName() : name.toString();
        if (encode) {
            if (value.startsWith("/") && value.length() > 1) {
                value = value.substring(1);
            }
            value = value.replaceAll("[/@:]", "_");
        }
        return value;
    }

    private String formatRandom(String options) {
        long min = 0L;
        long max = 1L;
        if (!StringUtils.isNullOrEmpty(options)) {
            Matcher m = randomPattern.matcher(options);
            if (m.matches()) {
                if (m.group(3) != null) {
                    min = Long.parseLong(m.group(1));
                    max = Long.parseLong(m.group(3));
                } else {
                    max = Long.parseLong(m.group(1));
                }
            }
            if (min > max) {
                long l = min;
                min = max;
                max = l;
            }
        }
        return Long.toString(ThreadLocalRandom.current().nextLong(min, ++max));
    }

    private String formatTimestamp(long time, TimeZone timeZone, String format, String defaultFormat, boolean canOffset) {
        Matcher m;
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), timeZone.toZoneId());
        if (canOffset && (m = offsetPattern.matcher(format)).find() && (m.group(4).length() > 0 || m.end() == format.length())) {
            int offset = Integer.parseInt(m.group(2)) * (m.group(1).equals("+") ? 1 : -1);
            switch (m.group(3)) {
                case "s": {
                    dateTime = dateTime.plusSeconds(offset);
                    break;
                }
                case "m": {
                    dateTime = dateTime.plusMinutes(offset);
                    break;
                }
                case "h": {
                    dateTime = dateTime.plusHours(offset);
                    break;
                }
                case "d": {
                    dateTime = dateTime.plusDays(offset);
                    break;
                }
                case "M": {
                    dateTime = dateTime.plusMonths(offset);
                    break;
                }
                case "y": {
                    dateTime = dateTime.plusYears(offset);
                }
            }
            format = format.substring(m.end());
            if (format.isEmpty()) {
                format = defaultFormat;
            }
        }
        if (format.equals(FORMAT_EPOCH)) {
            return Long.toString(dateTime.toInstant().toEpochMilli());
        }
        return TimeUtils.formatDateTime(dateTime, format, defaultFormat);
    }

    private String formatTriggerOutput(Output output, String options) {
        if (output == null || output.isEmpty()) {
            return "";
        }
        if (options != null) {
            List<String> opts = Arrays.asList(options.toLowerCase().split("\\s"));
            if (opts.contains("first")) {
                return output.getFirstLine();
            }
            if (opts.contains("last")) {
                return output.getLastLine();
            }
            Localise.logWarn(logger, "Unsupported trigger output option/s - %1$s", options);
        }
        return output.toString();
    }

    public static String insert(String format, String name, int start, int end) {
        if (StringUtils.isNullOrEmpty(format)) {
            return "{{ " + name + " }}";
        }
        int length = format.length();
        if (start < 0) {
            start = 0;
        } else if (start > length) {
            start = length;
        }
        if (end < start) {
            end = start;
        } else if (end > length) {
            end = length;
        }
        String prefix = format.substring(0, start);
        int prefixStart = prefix.lastIndexOf("{{");
        int prefixEnd = prefix.indexOf("}}");
        if (prefixStart > prefixEnd) {
            start = prefixStart;
        }
        String suffix = format.substring(end);
        int suffixStart = suffix.indexOf("{{");
        int suffixEnd = suffix.indexOf("}}");
        if (suffixEnd > -1 && (suffixStart < 0 || suffixEnd < suffixStart)) {
            end = end + suffixEnd + 2;
        }
        return String.format("%1$s{{ %2$s }}%3$s", format.substring(0, start), name, format.substring(end));
    }

    static {
        runtimeVariables.add("dir.tmp");
        runtimeVariables.add("job.description");
        runtimeVariables.add("job.host");
        runtimeVariables.add("job.user");
        runtimeVariables.add("job.name");
        runtimeVariables.add("random");
        runtimeVariables.add("trigger.name");
        runtimeVariables.add("trigger.result");
        runtimeVariables.add("trigger.value");
        runtimeVariables.add("trigger.message");
        runtimeVariables.add("trigger.output");
        runtimeVariables.add("trigger.time");
        runtimeVariables.add("trigger.time.next");
        runtimeVariables.add("time");
    }
}

