/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.calendar.CalendarInstance;
import com.beyondcron.core.schedule.CalendarSchedule;
import com.beyondcron.core.schedule.CalendarScheduleBuilder;
import java.util.Date;
import org.apache.logging.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.AbstractTrigger;

public class CalendarTrigger
extends AbstractTrigger {
    private static final Logger logger = LogUtils.getLogger(CalendarTrigger.class);
    private CalendarSchedule.Boundary boundary = CalendarSchedule.Boundary.START;
    private CalendarSchedule.Direction offsetDirection = CalendarSchedule.Direction.BEFORE;
    private Period offset = new Period();
    private CalendarInstance calendar = null;
    private long offsetStart = 0L;
    private long offsetEnd = 0L;
    private Date startTime = new Date();
    private Date endTime = null;
    private Date previousFireTime = null;
    private Date nextFireTime = null;

    public CalendarSchedule.Boundary getBoundary() {
        return this.boundary;
    }

    public void setBoundary(CalendarSchedule.Boundary boundary) {
        this.boundary = boundary;
        this.setOffset(this.offset);
    }

    public CalendarSchedule.Direction getOffsetDirection() {
        return this.offsetDirection;
    }

    public void setOffsetDirection(CalendarSchedule.Direction offsetDirection) {
        this.offsetDirection = offsetDirection;
        this.setOffset(this.offset);
    }

    public Period getOffset() {
        return this.offset;
    }

    public void setOffset(Period offset) {
        this.offset = offset;
        int value = offset.getValue();
        if (value != 0) {
            switch (this.offsetDirection) {
                case BEFORE: {
                    this.offsetEnd = this.offsetStart = offset.getMilliseconds() * -1L;
                    break;
                }
                case AFTER: {
                    this.offsetEnd = this.offsetStart = offset.getMilliseconds();
                    break;
                }
                case INSIDE: {
                    this.offsetStart = offset.getMilliseconds();
                    this.offsetEnd = this.offsetStart * -1L;
                    break;
                }
                case OUTSIDE: {
                    this.offsetEnd = offset.getMilliseconds();
                    this.offsetStart = this.offsetEnd * -1L;
                }
            }
        } else {
            this.offsetStart = 0L;
            this.offsetEnd = 0L;
        }
    }

    private void setCalendar(Calendar calendar) {
        try {
            this.calendar = (CalendarInstance)calendar;
        }
        catch (ClassCastException e) {
            this.calendar = null;
            Localise.logError(logger, "cannot cast %1$s to com.beyondcron.core.calendar.Calendar", calendar.getClass().getName());
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public Date getFinalFireTime() {
        return null;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public Date getFireTimeAfter(Date afterTime) {
        Date time = null;
        if (this.calendar == null && logger.isDebugEnabled()) {
            Localise.logDebug(logger, "Schedule has no calendar", new Object[0]);
            return null;
        }
        int value = this.offset.getValue();
        switch (this.boundary) {
            case START: {
                time = value != 0 ? new Date(afterTime.getTime() - this.offsetStart) : afterTime;
                time = this.calendar.getNextStartTime(time);
                if (value == 0 || time == null) break;
                time = new Date(time.getTime() + this.offsetStart);
                break;
            }
            case END: {
                time = value != 0 ? new Date(afterTime.getTime() - this.offsetEnd) : afterTime;
                time = this.calendar.getNextEndTime(time);
                if (value == 0 || time == null) break;
                time = new Date(time.getTime() + this.offsetEnd);
                break;
            }
            case BOTH: {
                time = value != 0 ? new Date(afterTime.getTime() - this.offsetStart) : afterTime;
                Date timeStart = this.calendar.getNextStartTime(time);
                time = value != 0 ? new Date(afterTime.getTime() - this.offsetEnd) : afterTime;
                Date timeEnd = this.calendar.getNextEndTime(time);
                if (timeStart != null) {
                    if (timeEnd != null) {
                        if (timeStart.before(timeEnd)) {
                            time = value != 0 ? new Date(timeStart.getTime() + this.offsetStart) : timeStart;
                            break;
                        }
                        time = value != 0 ? new Date(timeEnd.getTime() + this.offsetEnd) : timeEnd;
                        break;
                    }
                    time = value != 0 ? new Date(timeStart.getTime() + this.offsetStart) : timeStart;
                    break;
                }
                time = timeEnd != null ? (value != 0 ? new Date(timeEnd.getTime() + this.offsetEnd) : timeEnd) : null;
            }
        }
        return time;
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        this.triggered(calendar);
        this.previousFireTime = null;
        return this.nextFireTime;
    }

    public void triggered(Calendar calendar) {
        this.setCalendar(calendar);
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        this.setCalendar(calendar);
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        return misfireInstruction == -1 || misfireInstruction == 0;
    }

    public void updateAfterMisfire(Calendar calender) {
        this.setCalendar(this.calendar);
        this.nextFireTime = this.getFireTimeAfter(new Date());
    }

    public ScheduleBuilder<CalendarTrigger> getScheduleBuilder() {
        return CalendarScheduleBuilder.calendarSchedule().withBoundary(this.getBoundary()).withOffsetDirection(this.getOffsetDirection()).withOffset(this.getOffset());
    }
}

