/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.core.schedule.cron.ScheduleConverter;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;

public class CronSchedule
extends Schedule {
    private static final Logger logger = LogUtils.getLogger(CronSchedule.class);
    public static final String JSON_EXPRESSION = "expression";
    private static final List<String> cronDayName = List.of("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN", "*", "?");
    private static final List<String> cronDayNameLast = List.of("SUNL", "MONL", "TUEL", "WEDL", "THUL", "FRIL", "SATL");
    private CronExpression expression;
    private ScheduleConverter converter = null;

    protected CronSchedule() {
    }

    public CronSchedule(String expression) throws ParseException {
        this(null, Job.Action.START, expression);
    }

    public CronSchedule(Job job, Job.Action action, String expression) throws ParseException {
        super(job, action);
        this.setExpression(expression);
    }

    public String getExpression() {
        return this.expression.toString();
    }

    public void setExpression(String expression) throws ParseException {
        try {
            this.expression = new CronExpression(CronSchedule.convertExpression(expression));
        }
        catch (ParseException e) {
            String msg = Localise.format("Invalid cron expression %1$s - %2$s", expression, e.getMessage());
            logger.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public boolean canConvertSchedule() {
        return this.getConverter().canConvert();
    }

    public List<Schedule> convertSchedule() {
        return this.getConverter().getSchedules();
    }

    private ScheduleConverter getConverter() {
        if (this.converter == null) {
            this.converter = new ScheduleConverter(this);
        }
        return this.converter;
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.CRON;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        return this.getExpression();
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        return CronScheduleBuilder.cronSchedule((CronExpression)this.expression).inTimeZone(this.getTimeZone());
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(JSON_EXPRESSION, this.expression.getCronExpression());
        return json;
    }

    @Override
    public CronSchedule fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        try {
            this.expression = new CronExpression(json.getString(JSON_EXPRESSION));
        }
        catch (ParseException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_EXPRESSION, json.getString(JSON_EXPRESSION)));
        }
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.CronSchedule.Builder builder = ProtoJob.CronSchedule.newBuilder();
        builder.setExpression(this.expression.getCronExpression());
        baseBuilder.setCronExt(builder);
        return baseBuilder;
    }

    @Override
    public CronSchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.CronSchedule proto = ProtoJob.Schedule.parseFrom(data).getCronExt();
        super.fromProto(data);
        try {
            this.expression = new CronExpression(proto.getExpression());
        }
        catch (ParseException e) {
            Localise.logError(logger, e, "Invalid cron expression %1$s", this.expression);
        }
        return this;
    }

    public static boolean isValidExpression(String expression) {
        try {
            new CronExpression(CronSchedule.convertExpression(expression));
        }
        catch (ParseException e) {
            Localise.logDebug(logger, "%1$s - %2$s", expression, e.getMessage());
            return false;
        }
        return true;
    }

    public static String convertExpression(String expression) throws ParseException {
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(expression.split("\\s+")));
        while (values.size() < 6) {
            values.add(0, "0");
        }
        if (((String)values.get(3)).equals("*") && !((String)values.get(5)).equals("?")) {
            values.set(3, "?");
        } else if (((String)values.get(5)).equals("*") && !((String)values.get(3)).equals("?")) {
            values.set(5, "?");
        }
        values.set(5, CronSchedule.convertToQuartzDays((String)values.get(5)));
        return StringUtils.join(" ", values);
    }

    public static CronExpression parseExpression(String expression) throws ParseException {
        return new CronExpression(CronSchedule.convertExpression(expression));
    }

    public static CronExpression parseExpressionOrNull(String expression) {
        if (!StringUtils.isNullOrEmpty(expression)) {
            try {
                return CronSchedule.parseExpression(expression);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static String convertToQuartzDays(String days) throws ParseException {
        String[] dayList;
        StringBuilder quartzDays = new StringBuilder();
        String suffix = "";
        for (char c : days.toUpperCase().toCharArray()) {
            if (Character.isDigit(c)) {
                quartzDays.append(cronDayName.get(Character.digit(c, 10) % 7));
                continue;
            }
            if (c == '#') {
                suffix = days.substring(days.indexOf(35));
                break;
            }
            quartzDays.append(c);
        }
        for (String day : dayList = quartzDays.toString().split("[,-]")) {
            if (cronDayName.contains(day) || cronDayNameLast.contains(day) && dayList.length == 1) continue;
            throw new ParseException("Invalid Day-of-Week value: '" + days + "'", 0);
        }
        return quartzDays + suffix;
    }
}

