/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.Day;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.Time;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.CronSchedule;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.proto.ProtoJob;
import com.beyondcron.messaging.proto.ProtoTime;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;

public class DailySchedule
extends Schedule {
    private static final Logger logger = LogUtils.getLogger(DailySchedule.class);
    public static final String JSON_DAYS = "days";
    public static final String JSON_TIME = "time";
    private Time time;
    private Set<Day> days = new TreeSet<Day>();
    private Set<String> cronDays = new TreeSet<String>();
    private CronExpression expression;

    protected DailySchedule() {
    }

    public DailySchedule(Time time, Day ... days) {
        this(null, Job.Action.START, time, CollectionUtils.asList(days));
    }

    public DailySchedule(Time time, Collection<Day> days) {
        this(null, Job.Action.START, time, days);
    }

    public DailySchedule(Job job, Job.Action action, Time time, Collection<Day> days) {
        super(job, action);
        this.time = time;
        this.days.addAll(Day.consolidateDays(CollectionUtils.asSet(days)));
        this.init();
    }

    private void init() {
        this.expression = null;
        this.cronDays.clear();
        if (this.days.size() < 1) {
            return;
        }
        for (Day day : this.days) {
            this.cronDays.addAll(day.getCronDays());
        }
        try {
            this.expression = CronSchedule.parseExpression(String.format("%d %d %d ? * %s", this.time.getSecond(), this.time.getMinute(), this.time.getHour(), StringUtils.join(",", this.cronDays)));
        }
        catch (ParseException e) {
            Localise.logFatal(logger, e, "Unexpected error creating cron expression", new Object[0]);
            Program.exit(1);
        }
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.DAILY;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        ArrayList<String> l = new ArrayList<String>();
        block5: for (Day day : Day.consolidateDays(this.days)) {
            switch (day) {
                case DAILY: {
                    l.add(Localise.format("Daily"));
                    continue block5;
                }
                case WEEKDAY: {
                    l.add(Localise.format("Weekdays"));
                    continue block5;
                }
                case WEEKEND: {
                    l.add(Localise.format("Weekends"));
                    continue block5;
                }
            }
            l.add(Localise.format(day.getAbbreviation()));
        }
        String s = StringUtils.join(", ", " & ", l);
        return Localise.format("%s at %s", s, this.time.toString());
    }

    public Set<Day> getDays() {
        return Collections.unmodifiableSet(this.days);
    }

    public Time getTime() {
        return this.time;
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        return CronScheduleBuilder.cronSchedule((CronExpression)this.expression).inTimeZone(this.getTimeZone());
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        JSONArray array = new JSONArray();
        if (!this.days.contains((Object)Day.DAILY)) {
            for (Day day : this.days) {
                array.put(day.toString());
            }
            json.put(JSON_DAYS, array);
        }
        json.put(JSON_TIME, this.time.toString());
        return json;
    }

    @Override
    public DailySchedule fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        this.days.clear();
        if (json.has(JSON_DAYS)) {
            JSONArray array = json.getJSONArray(JSON_DAYS);
            for (int i = 0; i < array.length(); ++i) {
                try {
                    this.days.add(Day.valueOf(array.getString(i).toUpperCase()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_DAYS, array.get(i).toString()));
                }
            }
        }
        switch (this.days.size()) {
            case 0: {
                this.days.add(Day.DAILY);
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.days = Day.consolidateDays(this.days);
            }
        }
        try {
            this.time = new Time(json.getString(JSON_TIME));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_TIME, json.getString(JSON_TIME)));
        }
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.DailySchedule.Builder builder = ProtoJob.DailySchedule.newBuilder();
        for (Day day : this.days) {
            builder.addDays(day.toProto());
        }
        builder.setTime(this.time.toProto());
        baseBuilder.setDailyExt(builder);
        return baseBuilder;
    }

    @Override
    public DailySchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.DailySchedule proto = ProtoJob.Schedule.parseFrom(data).getDailyExt();
        super.fromProto(data);
        this.days.clear();
        for (ProtoTime.Day day : proto.getDaysList()) {
            this.days.add(Day.fromProto(day));
        }
        this.time = new Time().fromProto(proto.getTime().toByteArray());
        this.init();
        return this;
    }
}

