/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.Day;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NumberUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Time;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.ParseException;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;

public class MonthlySchedule
extends Schedule {
    private static final Logger logger = LogUtils.getLogger(MonthlySchedule.class);
    public static final String JSON_DAY = "day";
    public static final String JSON_TIME = "time";
    public static final String JSON_DAY_OF_MONTH = "dayOfMonth";
    public static final String JSON_POSITION = "position";
    public static final String JSON_LAST = "last";
    public static final String LAST_DAY = "DAY";
    private Time time;
    private int dayOfMonth;
    private Day day;
    private int position;
    boolean last;
    private CronExpression expression;
    private String definition;

    protected MonthlySchedule() {
    }

    public MonthlySchedule(Time time, int dayOfMonth) {
        this(null, Job.Action.START, time, dayOfMonth, Day.DAILY, 1, false);
    }

    public MonthlySchedule(Time time, Day day, int position) {
        this(null, Job.Action.START, time, 0, day, position, false);
    }

    public MonthlySchedule(Time time, int dayOfMonth, Day day, int position, boolean last) {
        this(null, Job.Action.START, time, dayOfMonth, day, position, last);
    }

    public MonthlySchedule(Job job, Job.Action action, Time time, int dayOfMonth, Day day, int position, boolean last) {
        super(job, action);
        if (dayOfMonth < 0 || dayOfMonth > 31) {
            throw new IllegalArgumentException(Localise.format("day of month (%d) must be in the 0 - 31", dayOfMonth));
        }
        if (dayOfMonth > 0) {
            if (last) {
                throw new IllegalArgumentException(Localise.format("last cannot be true when day of month > 0"));
            }
            if (position != 1) {
                throw new IllegalArgumentException(Localise.format("position (%d) must be 1 when day of month > 0", position));
            }
        } else if (last) {
            if (position < -31 || position > 0) {
                throw new IllegalArgumentException(Localise.format("position (%s) must be in the range -31 - 0 when last is true", position));
            }
        } else if (position < 1 || position > 5) {
            throw new IllegalArgumentException(Localise.format("position (%s) must be in the range 1 - 5", position));
        }
        this.time = time;
        this.dayOfMonth = dayOfMonth;
        this.day = day;
        this.position = position;
        this.last = last;
        this.init();
    }

    private void init() {
        this.expression = null;
        String cronDayOfMonth = "?";
        String cronDayOfWeek = "?";
        if (this.dayOfMonth > 0) {
            if (this.day == Day.WEEKDAY) {
                cronDayOfMonth = String.format("%dW", this.dayOfMonth);
                this.definition = Localise.format("%s or closest weekday of month at %s", NumberUtils.getOrdinalHybrid(this.dayOfMonth), this.time.toString());
            } else {
                cronDayOfMonth = String.format("%d", this.dayOfMonth);
                this.definition = Localise.format("%s of month at %s", NumberUtils.getOrdinalHybrid(this.dayOfMonth), this.time.toString());
            }
        } else if (this.last && (this.day == Day.DAILY || this.day == Day.WEEKDAY)) {
            if (this.day == Day.DAILY) {
                if (this.position < -1) {
                    cronDayOfMonth = String.format("L%d", this.position);
                    this.definition = Localise.format("%s last day of month at %s", NumberUtils.getOrdinalHybrid(Math.abs(this.position)), this.time.toString());
                } else {
                    cronDayOfMonth = "L";
                    this.definition = Localise.format("Last day of month at %s", this.time.toString());
                }
            } else {
                cronDayOfMonth = "LW";
                this.definition = Localise.format("Last weekday of month at %s", this.time.toString());
            }
        } else {
            String dayOfWeek = this.day.getCronDays().iterator().next();
            if (this.last) {
                cronDayOfWeek = String.format("%sL", dayOfWeek);
                this.definition = Localise.format("last %s of month at %s", this.day.getName(), this.time.toString());
            } else if (this.position > 0) {
                cronDayOfWeek = String.format("%s#%d", dayOfWeek, this.position);
                this.definition = Localise.format("%s %s of month at %s", NumberUtils.getOrdinalHybrid(this.position), this.day.getName(), this.time.toString());
            } else {
                Localise.logWarn(logger, "Monthly schedule used instead of daily schedule", new Object[0]);
                cronDayOfWeek = dayOfWeek;
                this.definition = Localise.format("%ss at %s", this.day.getName(), this.time.toString());
            }
        }
        try {
            this.expression = new CronExpression(String.format("%d %d %d %s * %s", this.time.getSecond(), this.time.getMinute(), this.time.getHour(), cronDayOfMonth, cronDayOfWeek));
        }
        catch (ParseException e) {
            Localise.logFatal(logger, e, "Unexpected error creating cron expression", new Object[0]);
            Program.exit(1);
        }
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.MONTHLY;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        return this.definition;
    }

    public Day getDay() {
        return this.day;
    }

    public Time getTime() {
        return this.time;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isLast() {
        return this.last;
    }

    public String getExpression() {
        return this.expression.toString();
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        return CronScheduleBuilder.cronSchedule((CronExpression)this.expression).inTimeZone(this.getTimeZone());
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.day != Day.DAILY) {
            json.put(JSON_DAY, this.day.toString());
        }
        json.put(JSON_TIME, this.time.toString());
        if (this.dayOfMonth > 0) {
            json.put(JSON_DAY_OF_MONTH, this.dayOfMonth);
        }
        if (this.position != 1) {
            json.put(JSON_POSITION, Math.abs(this.position));
        }
        if (this.last) {
            json.put(JSON_LAST, true);
        }
        return json;
    }

    @Override
    public MonthlySchedule fromJSON(JSONObject json) {
        super.fromJSON(json);
        try {
            String s = json.optString(JSON_DAY, Day.DAILY.toString()).toUpperCase();
            this.day = s.equals(LAST_DAY) ? Day.DAILY : Day.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_DAY, json.get(JSON_DAY).toString()));
        }
        try {
            this.time = new Time(json.getString(JSON_TIME));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_TIME, json.getString(JSON_TIME)));
        }
        this.dayOfMonth = json.optInt(JSON_DAY_OF_MONTH);
        if (this.dayOfMonth < 0 || this.dayOfMonth > 31) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_DAY_OF_MONTH, json.get(JSON_DAY_OF_MONTH).toString()));
        }
        this.position = Math.abs(json.optInt(JSON_POSITION, 1));
        this.last = json.optBoolean(JSON_LAST, false);
        if (this.last) {
            this.position *= -1;
        }
        this.init();
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.MonthlySchedule.Builder builder = ProtoJob.MonthlySchedule.newBuilder();
        builder.setDay(this.day.toProto());
        builder.setTime(this.time.toProto());
        if (this.dayOfMonth > 0) {
            builder.setDayOfMonth(this.dayOfMonth);
        }
        if (this.position != 1) {
            builder.setPosition(this.position);
        }
        if (this.last) {
            builder.setLast(true);
        }
        baseBuilder.setMonthlyExt(builder);
        return baseBuilder;
    }

    @Override
    public MonthlySchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.MonthlySchedule proto = ProtoJob.Schedule.parseFrom(data).getMonthlyExt();
        super.fromProto(data);
        this.day = Day.fromProto(proto.getDay());
        this.time = new Time().fromProto(proto.getTime().toByteArray());
        this.dayOfMonth = proto.getDayOfMonth();
        this.position = proto.getPosition();
        this.last = proto.getLast();
        this.init();
        return this;
    }
}

