/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.Localise;
import com.beyondcron.core.Period;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.message.DateTime;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;

public class RepeatSchedule
extends Schedule {
    public static final String JSON_PERIOD = "period";
    public static final String JSON_EPOCH = "epoch";
    public static String dateTimeFormat = "HH:mm:ss dd/MM/yyyy";
    private Period period;
    private LocalDateTime epoch;
    private boolean simpleSchedule;

    protected RepeatSchedule() {
    }

    public RepeatSchedule(Period period) {
        this(null, Job.Action.START, period, null);
    }

    public RepeatSchedule(Period period, LocalDateTime epoch) {
        this(null, Job.Action.START, period, epoch);
    }

    public RepeatSchedule(Job job, Job.Action action, Period period) {
        this(job, action, period, null);
    }

    public RepeatSchedule(Job job, Job.Action action, Period period, LocalDateTime epoch) {
        super(job, action);
        this.setPeriod(period);
        this.epoch = epoch != null ? epoch : RepeatSchedule.getRandomEpoch();
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
        switch (period.getUnit()) {
            case SECOND: 
            case MINUTE: 
            case HOUR: {
                this.simpleSchedule = true;
                break;
            }
            default: {
                this.simpleSchedule = false;
            }
        }
    }

    public LocalDateTime getEpoch() {
        return this.epoch;
    }

    public void setEpoch(LocalDateTime epoch) {
        this.epoch = epoch;
    }

    public static LocalDateTime getRandomEpoch() {
        return LocalDateTime.now().minusSeconds((long)(Math.random() * (double)Period.Unit.WEEK.getUnitInSeconds()));
    }

    @Override
    public Schedule.Type getType() {
        return Schedule.Type.REPEAT;
    }

    @Override
    public String getDefinition(TimeZone timeZone) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Every %s", this.period.toString()));
        if (timeZone == null) {
            timeZone = TimeUtils.timeZoneUTC;
        }
        if (this.simpleSchedule && Period.Unit.DAY.getSeconds(1L) % this.period.getSeconds() == 0L) {
            sb.append(String.format(" from %s daily", TimeUtils.formatTime(this.epoch, timeZone)));
        } else {
            sb.append(String.format(" from %s", TimeUtils.format(this.epoch, timeZone)));
        }
        return sb.toString();
    }

    @Override
    public ScheduleBuilder<?> getScheduleBuilder() {
        switch (this.period.getUnit()) {
            case SECOND: {
                return SimpleScheduleBuilder.repeatSecondlyForever((int)this.period.getValue());
            }
            case MINUTE: {
                return SimpleScheduleBuilder.repeatMinutelyForever((int)this.period.getValue());
            }
            case HOUR: {
                return SimpleScheduleBuilder.repeatHourlyForever((int)this.period.getValue());
            }
        }
        CalendarIntervalScheduleBuilder builder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().inTimeZone(this.getTimeZone()).preserveHourOfDayAcrossDaylightSavings(true).skipDayIfHourDoesNotExist(false);
        switch (this.period.getUnit()) {
            case DAY: {
                builder.withIntervalInDays(this.period.getValue());
                break;
            }
            case WEEK: {
                builder.withIntervalInWeeks(this.period.getValue());
                break;
            }
            case MONTH: {
                builder.withIntervalInMonths(this.period.getValue());
                break;
            }
            case YEAR: {
                builder.withIntervalInYears(this.period.getValue());
            }
        }
        return builder;
    }

    @Override
    protected Date getStartTime() {
        return this.simpleSchedule ? this.getStartTimeRepeat() : this.getStartTimeInterval();
    }

    private Date getStartTimeInterval() {
        java.time.Period period;
        ZoneId zoneId = this.getTimeZone().toZoneId();
        ZonedDateTime now = ZonedDateTime.now(zoneId);
        ZonedDateTime time = this.epoch.atZone(zoneId);
        switch (this.period.getUnit()) {
            case DAY: {
                period = java.time.Period.ofDays(this.period.getValue());
                break;
            }
            case WEEK: {
                period = java.time.Period.ofWeeks(this.period.getValue());
                break;
            }
            case MONTH: {
                period = java.time.Period.ofMonths(this.period.getValue());
                break;
            }
            default: {
                period = java.time.Period.ofYears(this.period.getValue());
            }
        }
        while (time.isAfter(now)) {
            time = time.minus(period);
        }
        while (time.isBefore(now)) {
            time = time.plus(period);
        }
        return Date.from(time.toInstant());
    }

    private Date getStartTimeRepeat() {
        long period = this.period.getMilliseconds();
        long now = System.currentTimeMillis();
        long offset = (now - TimeUtils.getDate(this.epoch, this.getTimeZone()).getTime()) % period;
        if (offset > 0L) {
            offset = period - offset;
        } else if (offset < 0L) {
            offset *= -1L;
        }
        return new Date(now + offset);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(JSON_PERIOD, this.period.toString(true));
        json.put(JSON_EPOCH, this.epoch.format(DateTimeFormatter.ofPattern(dateTimeFormat)));
        return json;
    }

    @Override
    public RepeatSchedule fromJSON(JSONObject json) {
        super.fromJSON(json);
        try {
            this.setPeriod(new Period(json.getString(JSON_PERIOD)));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_PERIOD, json.getString(JSON_PERIOD)));
        }
        if (json.has(JSON_EPOCH)) {
            String value = json.optString(JSON_EPOCH, "");
            try {
                this.epoch = LocalDateTime.parse(value, DateTimeFormatter.ofPattern(dateTimeFormat));
            }
            catch (DateTimeParseException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_EPOCH, value));
            }
        } else {
            this.epoch = RepeatSchedule.getRandomEpoch();
        }
        return this;
    }

    @Override
    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder baseBuilder = super.toProto();
        ProtoJob.RepeatSchedule.Builder builder = ProtoJob.RepeatSchedule.newBuilder();
        builder.setPeriod(this.period.toProto());
        builder.setEpoch(new DateTime(this.epoch).toProto());
        baseBuilder.setRepeatExt(builder);
        return baseBuilder;
    }

    @Override
    public RepeatSchedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.RepeatSchedule proto = ProtoJob.Schedule.parseFrom(data).getRepeatExt();
        super.fromProto(data);
        this.setPeriod(new Period().fromProto(proto.getPeriod().toByteArray()));
        if (proto.hasEpoch()) {
            this.epoch = new DateTime(proto.getEpoch()).getDateTime();
        } else if (proto.hasEpochOld()) {
            this.epoch = TimeUtils.getLocalDateTime(new Date(proto.getEpochOld()), this.getTimeZone());
            logger.warn("parsing legacy date/time in RepeatSchedule {} - {}", (Object)Long.toString(proto.getEpochOld()), (Object)this.epoch.toString());
        } else {
            this.epoch = RepeatSchedule.getRandomEpoch();
        }
        return this;
    }
}

