/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.calendar.CalendarInstance;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.schedule.CalendarSchedule;
import com.beyondcron.core.schedule.CronSchedule;
import com.beyondcron.core.schedule.DailySchedule;
import com.beyondcron.core.schedule.DateSchedule;
import com.beyondcron.core.schedule.MonthlySchedule;
import com.beyondcron.core.schedule.RepeatSchedule;
import com.beyondcron.core.schedule.SolarSchedule;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public abstract class Schedule
implements Comparable<Schedule>,
Message<Schedule>,
JSON<Schedule> {
    static final Logger logger = LogUtils.getLogger(Schedule.class);
    public static final String JSON_TYPE = "type";
    public static final String JSON_ACTION = "action";
    private static final String MESSAGE_TAG = "schedule";
    public static final String SCHEDULE_ACTION = "action";
    public static final int MINIMUM_START_DELAY = 0;
    static long nextId = 1L;
    private Job job = null;
    private Job.Action action;
    private Trigger trigger = null;

    protected Schedule() {
    }

    public Schedule(Job job, Job.Action action) {
        this.job = job;
        this.action = action;
    }

    public TriggerKey getKey() {
        return new TriggerKey(this.job.getName().toString(), Long.toString(nextId++));
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Job.Action getAction() {
        return this.action;
    }

    public abstract Type getType();

    public abstract String getDefinition(TimeZone var1);

    public TimeZone getTimeZone() {
        return this.job != null ? this.job.getTimeZone() : TimeUtils.timeZoneUTC;
    }

    protected Date getStartTime() {
        return new Date(System.currentTimeMillis() + 0L);
    }

    public abstract ScheduleBuilder<?> getScheduleBuilder();

    public Trigger getTrigger() {
        if (this.trigger == null) {
            TriggerBuilder builder = TriggerBuilder.newTrigger().withSchedule(this.getScheduleBuilder()).usingJobData("action", this.action.toString()).startAt(this.getStartTime());
            if (this.job != null) {
                builder.withIdentity(this.getKey());
                builder.forJob(this.job.getKey());
                if (this.job.getCalendar() != null) {
                    builder.modifiedByCalendar(CalendarInstance.getInstanceName(this.job));
                }
            }
            this.trigger = builder.build();
        }
        return this.trigger;
    }

    public String toString() {
        return String.format("%s: %s: %s", StringUtils.capitalise((Object)this.action), this.getType().getLabel(), this.getDefinition(this.getTimeZone()));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        return this.compareTo((Schedule)obj) == 0;
    }

    @Override
    public int compareTo(Schedule that) {
        return this.toString().compareTo(that.toString());
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_TYPE, this.getType().toString());
        if (this.action != null && this.action != Job.Action.START) {
            json.put("action", this.action.toString());
        }
        return json;
    }

    @Override
    public Schedule fromJSON(JSONObject json) {
        if (json.has("action")) {
            try {
                this.action = Job.Action.valueOf(json.getString("action").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", "action", json.get("action").toString()));
            }
        } else {
            this.action = Job.Action.START;
        }
        return this;
    }

    public static Schedule parseFromJSON(JSONObject json, TimeZone timeZone) {
        try {
            switch (Type.valueOf(json.getString(JSON_TYPE))) {
                case CALENDAR: {
                    return new CalendarSchedule().fromJSON(json);
                }
                case CRON: {
                    return new CronSchedule().fromJSON(json);
                }
                case DAILY: {
                    return new DailySchedule().fromJSON(json);
                }
                case DATE: {
                    return new DateSchedule().fromJSON(json);
                }
                case MONTHLY: {
                    return new MonthlySchedule().fromJSON(json);
                }
                case REPEAT: {
                    return new RepeatSchedule().fromJSON(json);
                }
                case SOLAR: {
                    return new SolarSchedule().fromJSON(json);
                }
            }
            throw new JSONException(Localise.format("unsupported schedule type %s", JSON_TYPE));
        }
        catch (Exception e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_TYPE, json.getString(JSON_TYPE), e.getMessage()));
        }
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Schedule.Builder toProto() {
        ProtoJob.Schedule.Builder builder = ProtoJob.Schedule.newBuilder();
        builder.setType(this.getType().toProto());
        if (this.action != Job.Action.START) {
            builder.setAction(this.action.toProto());
        }
        return builder;
    }

    @Override
    public Schedule fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Schedule proto = ProtoJob.Schedule.parseFrom(data);
        this.action = Job.Action.fromProto(proto.getAction());
        return this;
    }

    public static Schedule parseFromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Schedule proto = ProtoJob.Schedule.parseFrom(data);
        switch (proto.getType()) {
            case CALENDAR: {
                return new CalendarSchedule().fromProto(data);
            }
            case CRON: {
                return new CronSchedule().fromProto(data);
            }
            case DAILY: {
                return new DailySchedule().fromProto(data);
            }
            case DATE: {
                return new DateSchedule().fromProto(data);
            }
            case MONTHLY: {
                return new MonthlySchedule().fromProto(data);
            }
            case REPEAT: {
                return new RepeatSchedule().fromProto(data);
            }
            case SOLAR: {
                return new SolarSchedule().fromProto(data);
            }
        }
        logger.error("Unsupported schedule received: {}", (Object)proto.getType());
        return null;
    }

    public static enum Type {
        CALENDAR(Localise.format("Calendar")),
        CRON(Localise.format("Cron")),
        DAILY(Localise.format("Daily")),
        DATE(Localise.format("Date")),
        MONTHLY(Localise.format("Monthly")),
        REPEAT(Localise.format("Repeat")),
        SOLAR(Localise.format("Sunrise/Sunset"));

        private final String label;
        private static final EnumMap<Type, ProtoJob.Schedule.Type> typeMap;

        private Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Type fromProto(ProtoJob.Schedule.Type type) {
            return typeMap.getA(type);
        }

        public ProtoJob.Schedule.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoJob.Schedule.Type>(Type.class, ProtoJob.Schedule.Type.class);
        }
    }
}

