/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.schedule.cron;

import com.beyondcron.core.FileUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.data.DataValidator;
import com.beyondcron.core.job.Command;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Condition;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.schedule.CronSchedule;
import com.beyondcron.messaging.CommandConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Import {
    private static Pattern descriptionPattern = Pattern.compile("^(\\[\\s*(\\S+)(\\s*:?\\s+(.+))?\\s*\\]\\s*)?(\\S.*)$");
    private static Pattern variablePattern = Pattern.compile("^(\\S+?)\\s*=\\s*(.*?)");
    private static Pattern commandPattern = Pattern.compile("^(\\S.+?) > (\\S+)?");
    private Name root;
    private boolean raw;
    private DataValidator data;
    private List<Error> errors = new ArrayList<Error>();

    public Import(Name root, boolean raw) {
        this(null, root, raw);
    }

    public Import(CommandConnection connection, Name root, boolean raw) {
        this.root = root;
        this.raw = raw;
        this.data = connection != null ? DataValidator.getInstance(connection.getHazelcast()) : null;
    }

    private void addError(Error.Type type, int lineNumber, String message) {
        this.errors.add(new Error(type, lineNumber, message));
    }

    private void addError(Error.Type type, int lineNumber, String message, Name name) {
        this.errors.add(new Error(type, lineNumber, message, name));
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public Collection<CommandJob> parse(File file, String hostName, TimeZone timeZone) throws IOException {
        String userName = file.getName();
        if (userName.indexOf(46) > 0) {
            userName = userName.substring(0, userName.indexOf(46));
        }
        return this.parse(new FileInputStream(file), hostName, userName, timeZone);
    }

    public Collection<CommandJob> parse(InputStream stream, String hostName, String userName, TimeZone defaultTimeZone) throws IOException {
        String line;
        TimeZone timezone = defaultTimeZone;
        Name calendar = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        this.errors.clear();
        LinkedHashMap<String, CommandJob> jobs = new LinkedHashMap<String, CommandJob>();
        HashSet<Name> jobNames = new HashSet<Name>();
        HashSet<Name> jobConditions = new HashSet<Name>();
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        int lineNumber = 0;
        String commentLine = "";
        int commentLineNumber = -1;
        while ((line = in.readLine()) != null) {
            Command command;
            Object expression;
            ++lineNumber;
            if ((line = line.trim()).startsWith("#")) {
                commentLine = line.substring(1).trim();
                commentLineNumber = lineNumber;
                continue;
            }
            if (line.isEmpty()) continue;
            Matcher matcher = variablePattern.matcher(line);
            if (matcher.matches()) {
                String string = matcher.group(1);
                String value = matcher.group(2);
                if (string.equals("CRON_TZ")) {
                    if (!StringUtils.isNullOrEmpty(value)) {
                        timezone = TimeUtils.getTimeZone(value);
                        if (timezone != null) continue;
                        this.addError(Error.Type.UNKNOWN_TIMEZONE, lineNumber, value);
                        timezone = defaultTimeZone;
                        continue;
                    }
                    timezone = defaultTimeZone;
                    continue;
                }
                if (string.equals("BEYONDCRON_CALENDAR")) {
                    if (!StringUtils.isNullOrEmpty(value)) {
                        Name n = Name.parse(value);
                        if (n == null) {
                            this.addError(Error.Type.ILLEGAL_NAME, lineNumber, value);
                        } else if (this.data == null || this.data.isCalendar(n)) {
                            calendar = n;
                        } else {
                            this.addError(Error.Type.UNKNOWN_CALENDAR, lineNumber, value, n);
                        }
                    } else {
                        calendar = null;
                    }
                }
                properties.add(new Property(StringUtils.unquote(matcher.group(1)), StringUtils.unquote(matcher.group(2))));
                continue;
            }
            String[] stringArray = line.split("\\s+");
            if (stringArray.length > 7 && CronSchedule.isValidExpression(StringUtils.join(" ", 0, 7, stringArray))) {
                expression = StringUtils.join(" ", 0, 7, stringArray);
                command = new Command(StringUtils.join(" ", StringUtils.range(7, stringArray.length, stringArray)));
            } else if (stringArray.length > 6 && CronSchedule.isValidExpression(StringUtils.join(" ", 0, 6, stringArray))) {
                expression = StringUtils.join(" ", 0, 6, stringArray);
                command = new Command(StringUtils.join(" ", StringUtils.range(6, stringArray.length, stringArray)));
            } else {
                expression = "0 " + StringUtils.join(" ", 0, 5, stringArray);
                command = new Command(StringUtils.join(" ", StringUtils.range(5, stringArray.length, stringArray)));
            }
            String jobId = this.getCommandId(command, properties);
            CommandJob job = (CommandJob)jobs.get(jobId);
            if (job == null) {
                URL outputFile = null;
                Matcher m = commandPattern.matcher(command.getCommand());
                if (m.matches()) {
                    try {
                        Command.validate(m.group(2));
                        File f = new File(m.group(2));
                        if (FileUtils.isAbsolute(f)) {
                            outputFile = f.toURI().toURL();
                            command = new Command(m.group(1));
                        }
                    }
                    catch (Exception e) {
                        outputFile = null;
                    }
                }
                try {
                    command.validate();
                }
                catch (IllegalArgumentException e) {
                    try {
                        command.toScript();
                    }
                    catch (IllegalStateException e2) {
                        this.addError(Error.Type.ILLEGAL_STATE, lineNumber, e2.getMessage());
                        continue;
                    }
                }
                Name name = null;
                String description = null;
                ArrayList<Condition> conditions = new ArrayList<Condition>();
                if (!this.raw && lineNumber - 1 == commentLineNumber) {
                    m = descriptionPattern.matcher(commentLine);
                    if (m.matches()) {
                        if (!StringUtils.isNullOrEmpty(m.group(2))) {
                            name = Name.parse(this.root, m.group(2));
                            if (name == null) {
                                this.addError(Error.Type.ILLEGAL_NAME, lineNumber, m.group(2));
                                continue;
                            }
                            if (this.data != null && this.data.exists(name)) {
                                this.addError(Error.Type.EXISTING_NAME, lineNumber, null, name);
                            } else if (jobNames.contains(name)) {
                                this.addError(Error.Type.DUPLICATE_NAME, lineNumber, null, name);
                            }
                        }
                        description = m.group(5);
                        if (!StringUtils.isNullOrEmpty(m.group(4))) {
                            for (String s : StringUtils.split(m.group(4).trim())) {
                                Name n = Name.parse(this.root, s);
                                if (n != null) {
                                    Condition condition = new Condition(Condition.Type.ALL, n, null, Status.Result.SUCCESS, null);
                                    conditions.add(condition);
                                    jobConditions.add(condition.getJob());
                                    continue;
                                }
                                this.addError(Error.Type.ILLEGAL_NAME, lineNumber, s);
                            }
                        }
                    } else {
                        description = commentLine.trim();
                    }
                }
                if (name == null) {
                    name = Name.parse(this.root, this.getCommandName(command));
                    String s = name.toString();
                    int i = 1;
                    while (jobNames.contains(name) || this.data != null && this.data.exists(name)) {
                        name = Name.parse(String.format("%s.%d", s, i++));
                    }
                }
                job = new CommandJob(name);
                jobs.put(jobId, job);
                jobNames.add(name);
                if (!StringUtils.isNullOrEmpty(description)) {
                    job.setDescription(description);
                }
                job.setTimeZone(timezone);
                if (calendar != null) {
                    job.setCalendar(calendar);
                }
                job.setHostName(hostName);
                job.setUserName(userName);
                job.setCommand(command);
                job.setProperties(properties);
                if (outputFile != null) {
                    job.setOutput(outputFile);
                }
                if (!conditions.isEmpty()) {
                    job.addConditions(conditions);
                }
            }
            if (!job.hasCondition()) {
                try {
                    CronSchedule schedule = new CronSchedule((String)expression);
                    if (this.raw || !schedule.canConvertSchedule()) {
                        job.addSchedule(schedule);
                    } else {
                        job.addSchedules(schedule.convertSchedule());
                    }
                }
                catch (ParseException e) {
                    this.addError(Error.Type.CRON, lineNumber, line);
                }
            }
            job.setMode(Job.Mode.DISABLED);
        }
        for (Name name : jobConditions) {
            if (jobNames.contains(name) || this.data == null || this.data.exists(name)) continue;
            this.addError(Error.Type.UNKNOWN_CONDITION, -1, "", name);
        }
        return jobs.values();
    }

    private String getCommandId(Command command, Set<Property> properties) {
        StringBuilder sb = new StringBuilder(command.getCommand());
        for (Property property : properties) {
            sb.append(property.toString());
        }
        return sb.toString();
    }

    private String getCommandName(Command command) {
        String s = command.getCommand();
        int i = s.indexOf(32);
        if (i > 0) {
            s = s.substring(0, i);
        }
        return new File(s).getName();
    }

    public static class Error {
        private Type type;
        private int lineNumber;
        private String message;
        private Name name;

        private Error(Type type, int lineNumber, String message) {
            this(type, lineNumber, message, null);
        }

        private Error(Type type, int lineNumber, String message, Name name) {
            this.type = type;
            this.lineNumber = lineNumber;
            this.message = message;
            this.name = name;
        }

        public Type getType() {
            return this.type;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessage() {
            return this.message;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            switch (this.type) {
                case CRON: {
                    return Localise.format("invalid cron message at line %d - %s", this.lineNumber, this.message);
                }
                case ILLEGAL_NAME: {
                    return Localise.format("illegal name %d - %s", this.lineNumber, this.message);
                }
                case EXISTING_NAME: {
                    return Localise.format("job already exists at line %d - %s", this.lineNumber, this.name.toString());
                }
                case DUPLICATE_NAME: {
                    return Localise.format("duplicate job at line %d - %s", this.lineNumber, this.name.toString());
                }
                case UNKNOWN_CALENDAR: {
                    return Localise.format("unknown calendar at line %d - %s", this.lineNumber, this.name.toString());
                }
                case UNKNOWN_CONDITION: {
                    return Localise.format("unknown condition job - %s", this.name.toString());
                }
                case ILLEGAL_STATE: {
                    return Localise.format("illegal state at line %d - %s", this.lineNumber, this.message);
                }
                case UNKNOWN_TIMEZONE: {
                    return Localise.format("unknown timezone at line %d - %s", this.lineNumber, this.message);
                }
            }
            return "";
        }

        public static enum Type {
            CRON,
            ILLEGAL_NAME,
            EXISTING_NAME,
            DUPLICATE_NAME,
            UNKNOWN_CALENDAR,
            UNKNOWN_CONDITION,
            ILLEGAL_STATE,
            UNKNOWN_TIMEZONE;

        }
    }
}

