/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.security;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Role;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;

public class ACLValidator {
    static final Logger logger = LogUtils.getLogger(ACLValidator.class);
    private static Map<String, ACLValidator> validators = new HashMap<String, ACLValidator>();
    private HazelcastInstance hazelcast;
    private MultiMap<Name, ACL> acls;
    private MultiMap<Name, Name> aclGroups;

    public static synchronized ACLValidator getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        ACLValidator validator = validators.get(name);
        if (validator == null) {
            validator = new ACLValidator(hazelcast);
            validators.put(name, validator);
        }
        return validator;
    }

    protected ACLValidator(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.acls = Hazelcast.getACLMap(hazelcast);
        this.aclGroups = Hazelcast.getACLGroupMap(hazelcast);
    }

    public Collection<ACL> getACLs() {
        return this.acls.values();
    }

    public Collection<Name> getACLNames() {
        return this.acls.keySet();
    }

    public Collection<ACL> getACLs(Name name) {
        return this.getACLs(name, true);
    }

    public Collection<ACL> getACLs(Name name, boolean includeParent) {
        Name n = name;
        do {
            if (this.acls.containsKey((Object)n)) {
                return this.acls.get((Object)n);
            }
            if (includeParent) continue;
            return new HashSet<ACL>();
        } while ((n = n.getGroup()) != null);
        Collection c = this.acls.get((Object)Name.ROOT);
        return c != null ? c : new HashSet();
    }

    public Collection<ACL> getACLs(User user) {
        ArrayList<ACL> userAcls = new ArrayList<ACL>();
        IExecutorService executor = this.hazelcast.getExecutorService("UserACLs");
        try {
            for (Future acls : executor.submitToAllMembers((Callable)new UserACLs(new User(user))).values()) {
                userAcls.addAll((Collection)acls.get());
            }
        }
        catch (Exception e) {
            Localise.logError(logger, "Unexpected error getting ACls for user %1$s - %2$s", user.getName(), e.getMessage());
        }
        return userAcls;
    }

    public Collection<Name> getChildren(Name group) {
        return group != null ? Collections.unmodifiableCollection(this.aclGroups.get((Object)group)) : new ArrayList<Name>();
    }

    public Collection<ACL> getConsolidatedACLs(User user) {
        ArrayList<ACL> userAcls = new ArrayList<ACL>();
        IExecutorService executor = this.hazelcast.getExecutorService("ConsolidatedUserACLs");
        try {
            for (Future acls : executor.submitToAllMembers((Callable)new ConsolidatedUserACLs(new User(user))).values()) {
                userAcls.addAll((Collection)acls.get());
            }
        }
        catch (Exception e) {
            Localise.logError(logger, "Unexpected error getting consolidated ACls for user %1$s - %2$s", user.getName(), e.getMessage());
        }
        return userAcls;
    }

    public Collection<ACL> getACLs(Name name, User user) {
        return this.getACLs(name, user, ACL.Permission.ANY);
    }

    public Collection<ACL> getACLs(Name name, User user, ACL.Permission permission) {
        ArrayList<ACL> userAcls = new ArrayList<ACL>();
        for (ACL acl : this.getACLs(name)) {
            if (!acl.hasPermission(permission, user)) continue;
            userAcls.add(acl);
        }
        return userAcls;
    }

    public boolean hasACL(ACL acl) {
        IExecutorService executor = this.hazelcast.getExecutorService("ACLExists");
        try {
            return (Boolean)executor.submitToKeyOwner((Callable)new ACLExists(acl), (Object)acl.getName()).get();
        }
        catch (Exception e) {
            Localise.logError(logger, "Unexpected error checking if ACL %1$s exists - %2$s", acl.toString(), e.getMessage());
            return false;
        }
    }

    public boolean hasACL(Name name) {
        return name != null && this.acls.containsKey((Object)name);
    }

    public boolean hasACL(Name name, String userRole) {
        if (name == null) {
            return false;
        }
        IExecutorService executor = this.hazelcast.getExecutorService("NameRoleExists");
        try {
            return (Boolean)executor.submitToKeyOwner((Callable)new NameUserRoleExists(name, userRole), (Object)name).get();
        }
        catch (Exception e) {
            Localise.logError(logger, "Unexpected error checking if ACL %1$s:%2$s exists - %3$s", name.toString(), userRole, e.getMessage());
            return false;
        }
    }

    public boolean hasPermission(User user, ACL.Permission permission, Name name) {
        if (user.hasRole(Role.ADMIN_NAME)) {
            return true;
        }
        return this.getACLs(name, user, permission).size() > 0;
    }

    private static class ConsolidatedUserACLs
    implements Callable<List<ACL>>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private User user;

        public ConsolidatedUserACLs() {
        }

        public ConsolidatedUserACLs(User user) {
            this.user = user;
        }

        @Override
        public List<ACL> call() {
            ArrayList<ACL> userAcls = new ArrayList<ACL>();
            MultiMap<Name, ACL> acls = Hazelcast.getACLMap(this.hazelcast);
            for (Name name : acls.localKeySet()) {
                ACL userAcl = new ACL(name, this.user.getName(), new ACL.Permission[0]);
                for (ACL acl : acls.get((Object)name)) {
                    if (!acl.hasPermission(ACL.Permission.ANY, this.user)) continue;
                    userAcl.addPermissions(acl.getValue());
                }
                userAcls.add(userAcl);
            }
            return userAcls;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.user.toProto().build().toByteArray());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.user = new User().fromProto(in.readByteArray());
        }
    }

    private static class UserACLs
    implements Callable<List<ACL>>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private User user;

        private UserACLs() {
        }

        public UserACLs(User user) {
            this.user = user;
        }

        @Override
        public List<ACL> call() {
            ArrayList<ACL> userAcls = new ArrayList<ACL>();
            MultiMap<Name, ACL> acls = Hazelcast.getACLMap(this.hazelcast);
            for (Name name : acls.localKeySet()) {
                for (ACL acl : acls.get((Object)name)) {
                    if (!acl.hasPermission(ACL.Permission.ANY, this.user)) continue;
                    userAcls.add(acl);
                }
            }
            return userAcls;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.user.toProto().build().toByteArray());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.user = new User().fromProto(in.readByteArray());
        }
    }

    private static class NameUserRoleExists
    implements Callable<Boolean>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private Name name;
        private String userRole;

        private NameUserRoleExists() {
        }

        public NameUserRoleExists(Name name, String userRole) {
            this.name = name;
            this.userRole = userRole;
        }

        @Override
        public Boolean call() {
            MultiMap<Name, ACL> acls = Hazelcast.getACLMap(this.hazelcast);
            for (ACL acl : acls.get((Object)this.name)) {
                if (!acl.getUserRole().equals(this.userRole)) continue;
                return true;
            }
            return false;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.name.toProto().build().toByteArray());
            out.writeUTF(this.userRole);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.name = new Name().fromProto(in.readByteArray());
            this.userRole = in.readUTF();
        }
    }

    private static class ACLExists
    implements Callable<Boolean>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private ACL acl;

        private ACLExists() {
        }

        public ACLExists(ACL acl) {
            this.acl = acl;
        }

        @Override
        public Boolean call() {
            MultiMap<Name, ACL> acls = Hazelcast.getACLMap(this.hazelcast);
            return acls.get((Object)this.acl.getName()).contains(this.acl);
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.acl.toProto().build().toByteArray());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.acl = new ACL().fromProto(in.readByteArray());
        }
    }
}

