/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.security;

import com.beyondcron.core.Role;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class HostACLValidator {
    private static Map<String, HostACLValidator> validators = new HashMap<String, HostACLValidator>();
    public static final String userNamePattern = "user.name";
    private static final Pattern userNameRegex = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_-]*$");
    MultiMap<String, HostACL> acls;
    private MultiMap<Protected.Type, String> protectedNames;

    public static synchronized HostACLValidator getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        HostACLValidator validator = validators.get(name);
        if (validator == null) {
            validator = new HostACLValidator(hazelcast);
            validators.put(name, validator);
        }
        return validator;
    }

    protected HostACLValidator(HazelcastInstance hazelcast) {
        this.acls = Hazelcast.getACLHostMap(hazelcast);
        this.protectedNames = Hazelcast.getProtectedNames(hazelcast);
    }

    public Collection<HostACL> getACLs() {
        return this.acls.values();
    }

    public Collection<HostACL> getACLs(User user) {
        return this.getACLs(user, false);
    }

    private Collection<HostACL> getACLs(User user, boolean insertUserName) {
        String userName = user.getName();
        TreeSet<HostACL> list = new TreeSet<HostACL>(this.acls.get((Object)userName));
        for (String roleName : user.getRoles()) {
            list.addAll(this.acls.get((Object)roleName));
        }
        list.addAll(this.acls.get((Object)Role.EVERYONE_NAME));
        if (list.isEmpty()) {
            list.add(new HostACL(userName, userNamePattern, null));
        }
        if (insertUserName) {
            for (HostACL acl : list) {
                if (!acl.getUserPattern().equals(userNamePattern)) continue;
                acl.setUserPattern(userName);
            }
        }
        return list;
    }

    public Collection<HostACL> getACLs(String userRole) {
        return this.acls.get((Object)userRole);
    }

    public boolean hasACL(String userRole) {
        return this.acls.containsKey((Object)userRole);
    }

    public boolean hasPermission(User user, String userName, String hostName) {
        for (HostACL acl : this.getACLs(user, true)) {
            if (!this.hasPermission(acl, userName, hostName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(String userRole, String userName, String hostName) {
        for (HostACL acl : this.acls.get((Object)userRole)) {
            if (!this.hasPermission(acl, userName, hostName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(HostACL acl, String userName, String hostName) {
        if (!this.isValidUserName(userName)) {
            return false;
        }
        if (!acl.matches(userName, hostName)) {
            return false;
        }
        if (hostName != null && this.isProtected(Protected.Type.HOST, hostName) && !hostName.equals(acl.getHostPattern())) {
            return false;
        }
        return !this.isProtected(Protected.Type.USER, userName) || userName.equals(acl.getUserPattern());
    }

    public boolean hasHostPermission(User user, String hostName) {
        for (HostACL acl : this.getACLs(user, false)) {
            if (!this.hasHostPermission(acl, hostName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasHostPermission(HostACL acl, String hostName) {
        if (!acl.matchesHostName(hostName)) {
            return false;
        }
        return hostName == null || !this.isProtected(Protected.Type.HOST, hostName) || hostName.equals(acl.getHostPattern());
    }

    private Set<String> getUserNamePatterns(User user) {
        HashSet<String> names = new HashSet<String>();
        for (HostACL acl : this.getACLs(user, true)) {
            names.add(acl.getUserPattern());
        }
        return names;
    }

    public boolean canChangeUserName(User user) {
        Set<String> names = this.getUserNamePatterns(user);
        return names.size() == 1 ? !this.isValidUserName(names.iterator().next()) : true;
    }

    public String getDefaultUserName(User user) {
        String name = user.getName();
        if (this.isValidUserName(name) && this.hasUserPermission(user, name)) {
            return name;
        }
        Set<String> names = this.getUserNamePatterns(user);
        if (names.size() != 1) {
            return null;
        }
        name = names.iterator().next();
        return this.isValidUserName(name) ? name : null;
    }

    public boolean isValidUserName(String name) {
        return name != null && userNameRegex.matcher(name).matches();
    }

    public boolean hasUserPermission(User user, String userName) {
        for (HostACL acl : this.getACLs(user, true)) {
            if (!this.hasUserPermission(acl, userName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUserPermission(HostACL acl, String userName) {
        if (!this.isValidUserName(userName)) {
            return false;
        }
        if (!acl.matchesUserName(userName)) {
            return false;
        }
        return !this.isProtected(Protected.Type.USER, userName) || userName.equals(acl.getUserPattern());
    }

    public Collection<String> getProtectedNames(Protected.Type type) {
        return this.protectedNames.get((Object)type);
    }

    public boolean isProtected(Protected.Type type, String name) {
        return this.protectedNames.containsEntry((Object)type, (Object)name.toLowerCase());
    }
}

