/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.security;

import com.beyondcron.core.Configs;
import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Role;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.ACLValidator;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class UserACLValidator
implements EntryListener<Name, ACL> {
    private static Map<String, Map<User, UserACLValidator>> validators = new HashMap<String, Map<User, UserACLValidator>>();
    private User user;
    private boolean admin;
    private boolean adminUser;
    private ACLValidator validator;
    private Map<Name, ACL> userAcls = new TreeMap<Name, ACL>();
    private MultiMap<Name, ACL> acls;

    public static synchronized UserACLValidator getInstance(HazelcastInstance hazelcast, User user) {
        UserACLValidator validator;
        String name = hazelcast.getName();
        Map<User, UserACLValidator> userValidators = validators.get(name);
        if (userValidators == null) {
            userValidators = new HashMap<User, UserACLValidator>();
            validators.put(name, userValidators);
        }
        if ((validator = userValidators.get(user)) == null) {
            validator = new UserACLValidator(hazelcast, user);
            userValidators.put(user, validator);
        }
        return validator;
    }

    private UserACLValidator(HazelcastInstance hazelcast, User user) {
        this.validator = ACLValidator.getInstance(hazelcast);
        this.setUser(user);
        this.acls = Hazelcast.getACLMap(hazelcast);
        this.acls.addEntryListener((EntryListener)this, false);
        this.refresh();
    }

    public User getUser() {
        return this.user;
    }

    private void setUser(User user) {
        this.user = user;
        this.admin = user.hasRole(Role.ADMIN_NAME);
        this.adminUser = user.getName().equals(Configs.get("beyondcron.admin.user.name"));
    }

    public Collection<ACL> getConsolidatedACLs() {
        return Collections.unmodifiableCollection(this.userAcls.values());
    }

    public boolean hasACLs(Name name) {
        return this.acls.containsKey((Object)name);
    }

    public ACL getACLs(Name name) {
        Name n = name;
        do {
            ACL acl;
            if ((acl = this.userAcls.get(n)) == null) continue;
            return acl;
        } while ((n = n.getGroup()) != null);
        return this.userAcls.get(Name.ROOT);
    }

    public boolean hasPermission(Name name, ACL.Permission permission) {
        return this.getACLs(name).hasPermission(permission);
    }

    public boolean hasPermission(Name name, ACL.Permission ... permissions) {
        return this.getACLs(name).hasPermission(permissions);
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isAdminUser() {
        return this.adminUser;
    }

    public void refreshUser(User user) {
        if (!this.user.getName().equals(user.getName())) {
            throw new IllegalArgumentException("cannot refresh with a different user");
        }
        if (!JSONUtils.equals(this.user, user)) {
            this.setUser(user);
            this.refresh();
        }
    }

    private void refresh() {
        this.userAcls.clear();
        for (ACL acl : this.validator.getConsolidatedACLs(this.user)) {
            this.userAcls.put(acl.getName(), acl);
        }
    }

    public void entryAdded(EntryEvent<Name, ACL> event) {
        this.refresh();
    }

    public void entryRemoved(EntryEvent<Name, ACL> event) {
        this.refresh();
    }

    public void entryUpdated(EntryEvent<Name, ACL> event) {
        this.refresh();
    }

    public void entryEvicted(EntryEvent<Name, ACL> event) {
    }

    public void mapEvicted(MapEvent event) {
    }

    public void mapCleared(MapEvent event) {
        this.refresh();
    }
}

