/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.user;

import com.beyondcron.core.Configs;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class LocalUser
extends User {
    static final Logger logger = LogUtils.getLogger(LocalUser.class);
    private File passwordFile;
    private boolean savePassword;

    public LocalUser(String name, String description, String password) {
        this(name, description, password, true);
    }

    public LocalUser(String name, String description, String password, boolean savePassword) {
        super(name, description);
        this.passwordFile = LocalUser.getPasswordFile(name);
        this.savePassword = savePassword;
        this.setPassword(password);
    }

    public static boolean isUser(String name) {
        return LocalUser.getPasswordFile(name).exists();
    }

    public static LocalUser getUser(String name) {
        String password = LocalUser.getPassword(name);
        if (password != null) {
            return new LocalUser(name, "", password, false);
        }
        throw new IllegalArgumentException("local password file for " + name + " does not exist");
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public static File getPasswordFile(String name) {
        File dir;
        String dirName = FileUtils.expandHome((String)Configs.get("beyondcron.user.password.directory"));
        try {
            dir = FileUtils.checkDirectory(new File(dirName), null, true);
        }
        catch (IOException e) {
            dir = FileUtils.temporaryDirectory;
            Localise.logError(logger, "%1$s, using %2$s instead", e.getMessage(), dir.toString());
        }
        return new File(dir, StringUtils.hashString(System.getProperty("user.name") + name));
    }

    public String getPassword() {
        return LocalUser.getPassword(this.passwordFile);
    }

    public static String getPassword(String name) {
        return LocalUser.getPassword(LocalUser.getPasswordFile(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getPassword(File file) {
        String password;
        block12: {
            BufferedReader in;
            password = null;
            try {
                in = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                Localise.logError(logger, "File not found %1$s", file);
                return null;
            }
            password = in.readLine();
            try {
                in.close();
            }
            catch (IOException e) {
                Localise.logError(logger, e, "Could not close %1$s", file);
            }
            break block12;
            catch (IOException e) {
                try {
                    Localise.logError(logger, e, "Could not read %1$s", file);
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        Localise.logError(logger, e2, "Could not close %1$s", file);
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException e3) {
                    Localise.logError(logger, e3, "Could not close %1$s", file);
                }
            }
        }
        return password;
    }

    @Override
    public final void setPassword(String password) {
        super.setPassword(password);
        if (this.savePassword) {
            this.savePassword(password);
        }
    }

    private void savePassword(String password) {
        File dir;
        FileWriter out = null;
        if (this.passwordFile == null) {
            this.passwordFile = LocalUser.getPasswordFile(this.getName());
            this.passwordFile.deleteOnExit();
        }
        if (!(dir = this.passwordFile.getParentFile()).exists()) {
            if (!dir.mkdirs()) {
                Localise.logError(logger, "Could not create %1$s", dir.toPath());
                return;
            }
            dir.setReadable(false, false);
            dir.setReadable(true);
            dir.setWritable(false, false);
            dir.setWritable(true);
            dir.setExecutable(false, false);
            dir.setExecutable(true);
        }
        try {
            out = new FileWriter(this.passwordFile);
            out.write(password);
            out.write(10);
            out.close();
        }
        catch (IOException e) {
            Localise.logError(logger, e, "Problem creating password file %1$s", this.passwordFile);
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.passwordFile.delete();
            }
            return;
        }
        this.passwordFile.setReadable(false, false);
        this.passwordFile.setReadable(true);
        this.passwordFile.setWritable(false, false);
        this.passwordFile.setWritable(true);
        this.passwordFile.setExecutable(false, false);
    }
}

