/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.user;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Role;
import com.beyondcron.core.Service;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.User;
import com.hazelcast.core.HazelcastInstance;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

public abstract class UserService
extends Service {
    private boolean createUser;
    private boolean updateUser;
    private boolean deleteUser;
    private boolean validateUser;
    private boolean changePassword;
    private boolean resetPassword;

    public static UserService getService() throws ServiceException {
        return UserService.getService(null);
    }

    public static UserService getService(HazelcastInstance hazelcast) throws ServiceException {
        UserService service = null;
        String serviceName = (String)Configs.get("beyondcron.user.service");
        String className = Service.getClassName(serviceName, Service.Type.USER);
        if (!StringUtils.isNullOrEmpty(className)) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new ServiceException(Localise.format("User service class does not exist - %s", className));
            }
            catch (ClassCastException e) {
                throw new ServiceException(Localise.format("Class does not implement UserService - %s", className));
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(HazelcastInstance.class);
                service = (UserService)constructor.newInstance(hazelcast);
                Configs.addConfigs(clazz);
            }
            catch (NoSuchMethodException e) {
                try {
                    service = (UserService)clazz.newInstance();
                }
                catch (Exception e1) {
                    throw new ServiceException(Localise.format("Could not load user service %s - %s", className, e.getMessage()));
                }
            }
            catch (InvocationTargetException e) {
                throw new ServiceException(Localise.format("Could not load user service %s - %s", className, e.getCause().getMessage()));
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format("Could not load user service %s - %s", className, e.getMessage()), e);
            }
            service.setHazelcast(hazelcast);
            service.connect();
        }
        return service;
    }

    protected UserService(String name) {
        super(Service.Type.USER, name, true);
    }

    @Override
    protected void init() throws ServiceException {
        this.createUser = (Boolean)Configs.get("beyondcron.user.service.user.create");
        this.updateUser = (Boolean)Configs.get("beyondcron.user.service.user.update");
        this.deleteUser = (Boolean)Configs.get("beyondcron.user.service.user.delete");
        this.validateUser = (Boolean)Configs.get("beyondcron.user.service.user.validate");
        this.changePassword = (Boolean)Configs.get("beyondcron.user.service.password.change");
        this.resetPassword = (Boolean)Configs.get("beyondcron.user.service.password.reset");
    }

    public abstract User authenticateUser(String var1, String var2) throws ServiceException;

    public User getUser(String name) {
        return this.getUser(name, false);
    }

    public abstract User getUser(String var1, boolean var2);

    public abstract Set<User> getUsers(Filter var1);

    public abstract boolean isUser(String var1);

    public abstract Role getRole(String var1);

    public abstract Set<Role> getRoles(Filter var1);

    public abstract boolean isRole(String var1);

    public void refresh() {
    }

    public boolean canCreateUser() {
        return this.createUser;
    }

    public User createUser(User user, String password) throws ServiceException {
        throw new ServiceException("User create not supported");
    }

    public boolean canUpdateUser() {
        return this.updateUser;
    }

    public User updateUser(User user) throws ServiceException {
        throw new ServiceException("User update not supported");
    }

    public boolean canDeleteUser() {
        return this.deleteUser;
    }

    public boolean deleteUser(String name) throws ServiceException {
        throw new ServiceException("User delete not supported");
    }

    public boolean isValidateUser() {
        return this.validateUser;
    }

    public boolean canChangePassword() {
        return this.changePassword;
    }

    public void changePassword(String name, String oldPassword, String newPassword) throws ServiceException {
        throw new ServiceException("Password change not supported");
    }

    public boolean canResetPassword() {
        return this.resetPassword;
    }

    public void resetPassword(String name) throws ServiceException {
        throw new ServiceException("Password reset not supported");
    }

    public void resetPassword(String name, String token, String newPassword) throws ServiceException {
        throw new ServiceException("Password reset not supported");
    }
}

