/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging;

import com.beyondcron.core.Configs;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.LocalUser;
import com.beyondcron.messaging.Connection;
import com.beyondcron.messaging.ConnectionException;
import java.io.IOException;
import java.util.Collection;
import org.apache.logging.log4j.Logger;

public class AgentConnection
extends Connection {
    static final Logger logger = LogUtils.getLogger(AgentConnection.class);
    private static LocalUser user;

    public AgentConnection(Collection<InetSocketAddress> servers, boolean sshAgent) throws ConnectionException {
        super(user.getName(), null, sshAgent ? Connection.Type.AGENT_SSH : Connection.Type.AGENT, servers);
        Localise.logInfo(logger, "Connected to %s cluster", this.getClusterName());
    }

    static {
        try {
            String s = Configs.getPassword("BEYONDCRON_AGENT_USER_PASSWORD");
            if (StringUtils.isNullOrEmpty(s)) {
                Localise.logError(logger, "Agent password %s is empty or undefined", "BEYONDCRON_AGENT_USER_PASSWORD");
                Program.exit(1);
            }
            user = new LocalUser((String)Configs.get("BEYONDCRON_AGENT_USER_NAME"), (String)Configs.get("BEYONDCRON_AGENT_USER_DESCRIPTION"), StringUtils.hashString(s));
        }
        catch (IOException e) {
            Localise.logFatal(logger, "Could not get agent password - %s", e.getMessage());
            Program.exit(1);
        }
    }
}

