/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging;

import com.beyondcron.core.ConfigService;
import com.beyondcron.core.Configs;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.LocalUser;
import com.beyondcron.messaging.ConnectionException;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.MessageSerializer;
import com.beyondcron.messaging.message.ConnectionRegister;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.nio.serialization.Serializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public abstract class Connection
implements LifecycleListener {
    private static final Logger logger = LogUtils.getLogger(Connection.class);
    private static int POLL_TIMEOUT = 10;
    private static TimeUnit POLL_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private Type type;
    private String userName;
    private String clusterName;
    protected Config serverConfig;
    protected ClientConfig clientConfig;
    private InetSocketAddress clientAddress;
    protected HazelcastInstance hazelcast = null;
    private LifecycleEvent.LifecycleState state = null;
    private com.beyondcron.messaging.message.Connection connection;
    private boolean authenticated = false;
    private boolean registered = false;
    private boolean closing = false;
    private Map<String, String> properties = new TreeMap<String, String>();
    protected ConnectionListener connectionListener = null;

    protected Connection(String userName, String userPassword, Type type, Collection<InetSocketAddress> servers) throws ConnectionException {
        this(userName, userPassword, type, servers, null);
    }

    protected Connection(String userName, String userPassword, Type type, Collection<InetSocketAddress> servers, InetSocketAddress clientAddress) throws ConnectionException {
        this.userName = userName;
        this.type = type;
        this.clientAddress = clientAddress;
        this.initConfig(servers);
        this.initHazelcast(userPassword);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void close() {
        if (this.hazelcast != null && !this.closing) {
            LifecycleService service;
            this.closing = true;
            if (this.state != LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED && (service = this.hazelcast.getLifecycleService()) != null && service.isRunning() && this.state != LifecycleEvent.LifecycleState.SHUTTING_DOWN && this.state != LifecycleEvent.LifecycleState.SHUTDOWN) {
                service.shutdown();
            }
            this.hazelcast = null;
        }
    }

    public Connection setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initConfig(Collection<InetSocketAddress> servers) {
        String configFileName;
        if (servers == null || servers.size() < 1) {
            InetSocketAddress self = NetUtils.parseInetSocketAddress("");
            ConfigService configService = Configs.getService();
            if (configService != null) {
                String serversProperty = "BEYONDCRON_SERVER_NAMES";
                String serverList = null;
                try {
                    serverList = configService.getProperty(serversProperty);
                }
                catch (ServiceException e) {
                    Localise.logFatal(logger, "Could not get server names from config service %s", configService.getServiceDescription(), e);
                    Program.exit(1);
                }
                servers = this.parseServers(configService.getServiceName(), serverList);
                if (this.type == Type.SERVER && !servers.contains(self)) {
                    int maxAttempts = (Integer)Configs.get("BEYONDCRON_CONFIG_SERVICE_UPDATE\u2013ATTEMPTS");
                    String actualServerList = null;
                    int i = 0;
                    while (i++ < maxAttempts) {
                        servers.add(self);
                        String newServerList = StringUtils.join(" ", new TreeSet<InetSocketAddress>(servers));
                        try {
                            actualServerList = configService.setProperty(serversProperty, newServerList, serverList);
                        }
                        catch (ServiceException e) {
                            Localise.logFatal(logger, e, "Could not update [%1$s]:%2$s", configService.getServiceName(), serversProperty);
                            Program.exit(1);
                        }
                        if (StringUtils.equals(actualServerList, newServerList) || (servers = this.parseServers(configService.getServiceName(), actualServerList)).contains(self)) break;
                        if (i >= maxAttempts) {
                            Localise.logFatal(logger, "Could not update [%1$s]:%2$s after %3$d attempts", configService.getServiceName(), serversProperty, maxAttempts);
                            Program.exit(1);
                        }
                        serverList = actualServerList;
                    }
                }
                if (servers.isEmpty()) {
                    Localise.logFatal(logger, "No servers defined in [%1$s]:%2$s", configService.getServiceName(), serversProperty);
                    Program.exit(1);
                }
            } else {
                servers = this.parseServers("env", (String)Configs.get("BEYONDCRON_SERVER_NAMES"));
                if (servers.isEmpty()) {
                    servers.add(self);
                }
            }
        }
        InputStream configStream = null;
        String string = configFileName = this.type == Type.SERVER ? (String)Configs.get("HAZELCAST_CONFIG") : (String)Configs.get("HAZELCAST_CLIENT_CONFIG");
        if (!StringUtils.isNullOrEmpty(configFileName)) {
            if (configFileName.contains("\n")) {
                configStream = StringUtils.asStream(configFileName);
            } else {
                File configFile = new File(configFileName);
                if (!configFile.exists()) {
                    Localise.logFatal(logger, "Hazelcast config file %1$s does not exist", configFileName);
                    Program.exit(1);
                } else if (!configFile.canRead()) {
                    Localise.logFatal(logger, "Hazelcast config file %1$s is not readable", configFileName);
                    Program.exit(1);
                }
                try {
                    configStream = new FileInputStream(configFile);
                }
                catch (FileNotFoundException e) {
                    Localise.logFatal(logger, "Could not open Hazelcast config file %1$s - %2$s", configFileName, e.getMessage());
                    Program.exit(1);
                }
            }
        }
        if (this.type == Type.SERVER) {
            this.initServerConfig(configStream, servers);
            NetworkConfig config = this.serverConfig.getNetworkConfig();
            if (config.getPort() != Hazelcast.DEFAULT_PORT && config.getPort() != 5701) {
                Localise.logWarn(logger, "Overriding server port value %1$d in %2$s with %3$d", config.getPort(), configFileName, Hazelcast.DEFAULT_PORT);
                config.setPort(Hazelcast.DEFAULT_PORT);
            }
        } else {
            this.initClientConfig(configStream, servers);
        }
        if (configStream == null) return;
        try {
            configStream.close();
            return;
        }
        catch (IOException e) {
            Localise.logError(logger, "Error closing %1$s - %2$s", configFileName, e.getMessage());
        }
        return;
        catch (Exception e) {
            try {
                if (configFileName == null) {
                    Localise.logFatal(logger, "Error reading default Hazelcast configuration file - %1$s", e.getMessage());
                } else if (configFileName.contains("\n")) {
                    Localise.logFatal(logger, "Error reading Hazelcast configuration variable %1$s - %2$s", this.type == Type.SERVER ? "HAZELCAST_CONFIG" : "HAZELCAST_CLIENT_CONFIG", e.getMessage());
                } else {
                    Localise.logFatal(logger, "Error reading Hazelcast configuration file %1$s - %2$s", configFileName, e.getMessage());
                }
                if (configStream == null) return;
            }
            catch (Throwable throwable) {
                if (configStream == null) throw throwable;
                try {
                    configStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Localise.logError(logger, "Error closing %1$s - %2$s", configFileName, e2.getMessage());
                }
                throw throwable;
            }
            try {
                configStream.close();
                return;
            }
            catch (IOException e3) {
                Localise.logError(logger, "Error closing %1$s - %2$s", configFileName, e3.getMessage());
            }
            return;
        }
    }

    private Collection<InetSocketAddress> parseServers(String source, String serverList) {
        ArrayList<InetSocketAddress> servers = new ArrayList<InetSocketAddress>();
        for (String name : StringUtils.split(serverList)) {
            try {
                InetSocketAddress address = NetUtils.parseInetSocketAddress(name);
                if (!NetUtils.ping(address.getAddress())) continue;
                servers.add(address);
            }
            catch (IllegalArgumentException e) {
                Localise.logFatal(logger, "Invalid server name %1$s in [%2$s]:%3$s", name, source, serverList);
                Program.exit(1);
            }
        }
        if (logger.isDebugEnabled()) {
            Localise.logDebug(logger, "ParseServers: [%1$s]:%2$s - %3$s", source, serverList, StringUtils.join(" ", servers));
        }
        return servers;
    }

    private void initClientConfig(InputStream configStream, Collection<InetSocketAddress> servers) {
        ClientConfig config = configStream != null ? new XmlClientConfigBuilder(configStream).build() : new XmlClientConfigBuilder().build();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        boolean defaultConfig = config.getGroupConfig().equals((Object)new GroupConfig());
        if (defaultConfig) {
            switch (this.type) {
                case AGENT: 
                case AGENT_SSH: {
                    networkConfig.setSmartRouting(false);
                    networkConfig.setConnectionAttemptLimit(((Integer)Configs.get("HAZELCAST_AGENT_CONNECTION_ATTEMPT_LIMIT")).intValue());
                    networkConfig.setConnectionAttemptPeriod((int)((Period)Configs.get("HAZELCAST_AGENT_CONNECTION_ATTEMPT_PERIOD")).getMilliseconds());
                    break;
                }
                case COMMAND: {
                    networkConfig.setSmartRouting(false);
                    networkConfig.setConnectionAttemptLimit(((Integer)Configs.get("HAZELCAST_CLIENT_CONNECTION_ATTEMPT_LIMIT")).intValue());
                    networkConfig.setConnectionAttemptPeriod((int)((Period)Configs.get("HAZELCAST_CLIENT_CONNECTION_ATTEMPT_PERIOD")).getMilliseconds());
                    break;
                }
                case WEB: {
                    networkConfig.setSmartRouting(false);
                    networkConfig.setConnectionAttemptLimit(((Integer)Configs.get("HAZELCAST_WEB_CONNECTION_ATTEMPT_LIMIT")).intValue());
                    networkConfig.setConnectionAttemptPeriod((int)((Period)Configs.get("HAZELCAST_WEB_CONNECTION_ATTEMPT_PERIOD")).getMilliseconds());
                }
            }
        }
        if (StringUtils.isNullOrEmpty(config.getProperty("hazelcast.phone.home.enabled"))) {
            config.setProperty("hazelcast.phone.home.enabled", "false");
        }
        if (servers != null && servers.size() > 0) {
            for (InetSocketAddress server : new TreeSet<InetSocketAddress>(servers)) {
                networkConfig.addAddress(new String[]{server.toString()});
            }
        }
        this.setGroupConfig(config.getGroupConfig());
        this.setSerialisationConfig(config.getSerializationConfig());
        this.clientConfig = config;
    }

    private void initServerConfig(InputStream configStream, Collection<InetSocketAddress> servers) {
        Config config;
        Config config2 = config = configStream != null ? new XmlConfigBuilder(configStream).build() : new XmlConfigBuilder().build();
        if (servers != null && servers.size() > 0) {
            JoinConfig join;
            TcpIpConfig tcpIpConfig = new TcpIpConfig();
            for (InetSocketAddress server : new TreeSet<InetSocketAddress>(servers)) {
                tcpIpConfig.addMember(server.toString());
            }
            NetworkConfig networkConfig = config.getNetworkConfig();
            if (networkConfig == null) {
                networkConfig = new NetworkConfig();
                config.setNetworkConfig(networkConfig);
            }
            if ((join = networkConfig.getJoin()).getMulticastConfig() != null) {
                join.getMulticastConfig().setEnabled(false);
            }
            if (join.getAwsConfig() != null) {
                join.getAwsConfig().setEnabled(false);
            }
            tcpIpConfig.setEnabled(true);
            join.setTcpIpConfig(tcpIpConfig);
        }
        if (StringUtils.isNullOrEmpty(config.getProperty("hazelcast.phone.home.enabled"))) {
            config.setProperty("hazelcast.phone.home.enabled", "false");
        }
        this.setGroupConfig(config.getGroupConfig());
        this.setSerialisationConfig(config.getSerializationConfig());
        this.setTopicOrdering(config);
        MapConfig mapConfig = config.getMapConfig("acls");
        if (mapConfig == null) {
            mapConfig = new MapConfig("acls");
            NearCacheConfig nearCacheConfig = new NearCacheConfig();
            nearCacheConfig.setInvalidateOnChange(true);
            mapConfig.setNearCacheConfig(nearCacheConfig);
            config.addMapConfig(mapConfig);
        }
        config.setLiteMember(true);
        this.serverConfig = config;
    }

    private void initHazelcast(String password) throws ConnectionException {
        try {
            this.hazelcast = this.type == Type.SERVER ? com.hazelcast.core.Hazelcast.newHazelcastInstance((Config)this.serverConfig) : HazelcastClient.newHazelcastClient((ClientConfig)this.clientConfig);
            this.state = LifecycleEvent.LifecycleState.CLIENT_CONNECTED;
        }
        catch (Exception e) {
            Localise.logFatal(logger, "Could not connect to %s, tried connecting to the following addresses:", "BeyondCron");
            List servers = this.type == Type.SERVER ? this.serverConfig.getNetworkConfig().getJoin().getTcpIpConfig().getMembers() : this.clientConfig.getNetworkConfig().getAddresses();
            for (String server : servers) {
                Localise.logFatal(logger, "- %s", server);
            }
            if (this.type == Type.WEB) {
                throw new ConnectionException(ConnectionException.Reason.CONNECTION_ERROR, Localise.format("Could not connect to %s", "BeyondCron"));
            }
            Program.exit(1);
        }
        this.connection = new com.beyondcron.messaging.message.Connection(this.hazelcast.getLocalEndpoint().getUuid(), this.type.toString());
        if (this.clientAddress != null) {
            this.connection.setSocketAddress(this.clientAddress);
        } else {
            this.connection.setSocketAddress(new InetSocketAddress(this.hazelcast.getLocalEndpoint().getSocketAddress()));
        }
        this.connection.setClientUserName(this.userName);
        if (this.type != Type.SERVER) {
            this.register(password);
            Configs.setHazelcast(this.hazelcast);
        }
        this.hazelcast.getLifecycleService().addLifecycleListener((LifecycleListener)this);
    }

    public String getUserName() {
        return this.userName;
    }

    private void setGroupConfig(GroupConfig groupConfig) {
        if (groupConfig.getName().equals("dev")) {
            groupConfig.setName((String)Configs.get("BEYONDCRON_CLUSTER_NAME"));
        }
        this.clusterName = groupConfig.getName();
    }

    private void setSerialisationConfig(SerializationConfig serialisationConfig) {
        GlobalSerializerConfig globalConfig = new GlobalSerializerConfig();
        globalConfig.setImplementation((Serializer)new MessageSerializer());
        serialisationConfig.setGlobalSerializerConfig(globalConfig);
    }

    private void setTopicOrdering(Config config) {
        for (Field field : Hazelcast.class.getFields()) {
            String name = field.getName();
            if (!name.endsWith("_TOPIC")) continue;
            try {
                String topicName = (String)field.get(null);
                config.getTopicConfig(topicName).setGlobalOrderingEnabled(true);
            }
            catch (Exception e) {
                Localise.logError(logger, "Unexpected exception getting value of %1$s - %2$s", name, e.getMessage());
            }
        }
    }

    public com.beyondcron.messaging.message.Connection getConnection() {
        return this.connection;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public static String getClusterName(HazelcastInstance hazelcast) {
        return hazelcast.getConfig().getGroupConfig().getName();
    }

    public String getClientHostName() {
        return this.connection.getClientHostName();
    }

    public Connection setClientHostName(String hostName) {
        this.connection.setClientHostName(hostName);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String password) throws ConnectionException {
        String pwd;
        IMap<String, com.beyondcron.messaging.message.Connection> servers;
        IQueue<ConnectionRegister.Response> responseQueue = null;
        ConnectionRegister.Response response = null;
        this.registered = false;
        if (this.type != Type.SERVER && (servers = Hazelcast.getServerMap(this.hazelcast)).isEmpty()) {
            int attemptLimit = this.clientConfig.getNetworkConfig().getConnectionAttemptLimit();
            int attempPeriod = this.clientConfig.getNetworkConfig().getConnectionAttemptPeriod();
            do {
                try {
                    Thread.sleep(attempPeriod);
                }
                catch (InterruptedException e) {
                    Localise.logWarn(logger, "Unexpectedly interrupted", new Object[0]);
                    break;
                }
            } while (servers.isEmpty() && --attemptLimit != 0);
        }
        if (StringUtils.isNullOrEmpty(pwd = password) && this.type != Type.COMMAND && this.type != Type.WEB) {
            pwd = LocalUser.getPassword(this.userName);
        }
        if (!StringUtils.isNullOrEmpty(pwd)) {
            Hazelcast.getConnectionSendQueue(this.hazelcast).add((Object)new ConnectionRegister(this.connection, pwd));
        } else {
            Hazelcast.getConnectionSendQueue(this.hazelcast).add((Object)new ConnectionRegister(this.connection, false));
        }
        try {
            responseQueue = Hazelcast.getConnectionReceiveQueue(this.hazelcast);
            response = (ConnectionRegister.Response)responseQueue.poll((long)POLL_TIMEOUT, POLL_TIMEOUT_UNIT);
        }
        catch (InterruptedException e) {
            Localise.logWarn(logger, "Unexpectedly interrupted", new Object[0]);
        }
        finally {
            if (responseQueue != null) {
                responseQueue.destroy();
            }
        }
        if (response == null) {
            this.close();
            throw new ConnectionException(ConnectionException.Reason.TIMEOUT_ERROR, Localise.format("Timeout on authentication"));
        }
        if (!response.getResult().wasSuccess()) {
            this.close();
            throw new ConnectionException(ConnectionException.Reason.AUTHENTICATION_ERROR, response.getResult().getMessage());
        }
        this.authenticated = response.isAuthenticated();
        this.registered = true;
        this.properties.clear();
        this.properties.putAll(response.getProperties());
    }

    public HazelcastInstance getHazelcast() {
        return this.hazelcast;
    }

    public boolean isConnected() {
        return this.state == LifecycleEvent.LifecycleState.CLIENT_CONNECTED;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public synchronized void stateChanged(LifecycleEvent event) {
        this.state = event.getState();
        if (this.state == LifecycleEvent.LifecycleState.CLIENT_CONNECTED && this.type != Type.WEB) {
            String message;
            if (!this.registered) {
                try {
                    this.register(null);
                }
                catch (ConnectionException e) {
                    message = Localise.format("Could not register connection - %s", e.getMessage());
                    logger.fatal(message.toLowerCase());
                    if (this.connectionListener != null) {
                        this.connectionListener.closed(message);
                    }
                    this.close();
                }
            }
            message = Localise.format("Reconnected to cluster");
            logger.warn(message.toLowerCase());
            if (this.connectionListener != null) {
                this.connectionListener.connected(message);
            }
        } else if (this.state == LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) {
            this.registered = false;
            this.authenticated = false;
            String message = this.type != Type.WEB ? Localise.format("Disconnected from cluster, attempting to reconnect") : Localise.format("Disconnected from cluster");
            logger.warn(message);
            if (this.connectionListener != null) {
                this.connectionListener.disconnected(message);
            }
        } else if (this.state == LifecycleEvent.LifecycleState.SHUTDOWN) {
            if (!this.closing) {
                String message = Localise.format("Connection to cluster failed, cannot recover");
                logger.fatal(message);
                if (this.connectionListener != null) {
                    this.connectionListener.closed(message);
                }
            }
            this.hazelcast = null;
        }
    }

    public static enum Type {
        AGENT,
        AGENT_SSH,
        COMMAND,
        SERVER,
        WEB;

    }

    public static interface ConnectionListener {
        public void connected(String var1);

        public void disconnected(String var1);

        public void closed(String var1);

        public void locked(String var1);
    }
}

