/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging;

import com.beyondcron.core.License;
import com.beyondcron.core.Limit;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.Result;
import com.beyondcron.core.Role;
import com.beyondcron.core.ServiceStatus;
import com.beyondcron.core.Version;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.core.config.BooleanConfig;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.ConfigProperty;
import com.beyondcron.core.config.IntegerConfig;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.CalendarUpdateJob;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.ContainerJob;
import com.beyondcron.core.job.CustomJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobMode;
import com.beyondcron.core.job.MailJob;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.SQLJob;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.TriggerJob;
import com.beyondcron.core.job.URLJob;
import com.beyondcron.core.schedule.MonthlySchedule;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.ACLCommand;
import com.beyondcron.messaging.message.ACLList;
import com.beyondcron.messaging.message.ACLQuery;
import com.beyondcron.messaging.message.ACLUpdate;
import com.beyondcron.messaging.message.AgentQuery;
import com.beyondcron.messaging.message.Announcement;
import com.beyondcron.messaging.message.AnnouncementCommand;
import com.beyondcron.messaging.message.CalendarCommand;
import com.beyondcron.messaging.message.CalendarJobsQuery;
import com.beyondcron.messaging.message.CalendarQuery;
import com.beyondcron.messaging.message.CalendarUpdate;
import com.beyondcron.messaging.message.Change;
import com.beyondcron.messaging.message.ChangeQuery;
import com.beyondcron.messaging.message.ClusterQuery;
import com.beyondcron.messaging.message.ConfigCommand;
import com.beyondcron.messaging.message.ConfigQuery;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ConnectionAuthenticate;
import com.beyondcron.messaging.message.ConnectionQuery;
import com.beyondcron.messaging.message.ConnectionRegister;
import com.beyondcron.messaging.message.ConnectionUpdate;
import com.beyondcron.messaging.message.DateQuery;
import com.beyondcron.messaging.message.Group;
import com.beyondcron.messaging.message.GroupQuery;
import com.beyondcron.messaging.message.HostACLCommand;
import com.beyondcron.messaging.message.HostACLList;
import com.beyondcron.messaging.message.HostACLQuery;
import com.beyondcron.messaging.message.ICalendarCommand;
import com.beyondcron.messaging.message.ICalendarQuery;
import com.beyondcron.messaging.message.ICalendarUpdate;
import com.beyondcron.messaging.message.JobCommand;
import com.beyondcron.messaging.message.JobControl;
import com.beyondcron.messaging.message.JobExecute;
import com.beyondcron.messaging.message.JobHistoryClear;
import com.beyondcron.messaging.message.JobHistoryQuery;
import com.beyondcron.messaging.message.JobOutputQuery;
import com.beyondcron.messaging.message.JobQuery;
import com.beyondcron.messaging.message.JobStatusQuery;
import com.beyondcron.messaging.message.JobUpdate;
import com.beyondcron.messaging.message.LicenseCommand;
import com.beyondcron.messaging.message.LicenseQuery;
import com.beyondcron.messaging.message.LimitQuery;
import com.beyondcron.messaging.message.LimitReset;
import com.beyondcron.messaging.message.PersistCommand;
import com.beyondcron.messaging.message.PersistUpdate;
import com.beyondcron.messaging.message.PropertyCommand;
import com.beyondcron.messaging.message.PropertyList;
import com.beyondcron.messaging.message.PropertyQuery;
import com.beyondcron.messaging.message.PropertyUpdate;
import com.beyondcron.messaging.message.ProtectedCommand;
import com.beyondcron.messaging.message.ProtectedList;
import com.beyondcron.messaging.message.ProtectedQuery;
import com.beyondcron.messaging.message.Queue;
import com.beyondcron.messaging.message.QueueCommand;
import com.beyondcron.messaging.message.QueueQuery;
import com.beyondcron.messaging.message.RoleCommand;
import com.beyondcron.messaging.message.RoleQuery;
import com.beyondcron.messaging.message.RoleUpdate;
import com.beyondcron.messaging.message.ServerQuery;
import com.beyondcron.messaging.message.ServiceCommand;
import com.beyondcron.messaging.message.ServiceQuery;
import com.beyondcron.messaging.message.Topic;
import com.beyondcron.messaging.message.TopicQuery;
import com.beyondcron.messaging.message.UserCommand;
import com.beyondcron.messaging.message.UserPassword;
import com.beyondcron.messaging.message.UserQuery;
import com.beyondcron.messaging.message.UserRefresh;
import com.beyondcron.messaging.message.UserUpdate;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.messaging.message.calendar.ICalendar;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class MessageSerializer
implements ByteArraySerializer<Message<?>> {
    static final Logger logger = LogUtils.getLogger(MessageSerializer.class);
    private static Map<Class<?>, String> messageClassTag = new HashMap();
    private static Map<Class<?>, Integer> messageClassType = new HashMap();
    private static Map<String, Set<Class<?>>> messageTagClasses = new HashMap();
    private static Map<Integer, Class<?>> messageTypeClass = new HashMap();

    public static void registerMessages(Class<?> clazz) {
        if (Message.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Message message = (Message)constructor.newInstance(new Object[0]);
                String tag = message.getMessageTag();
                int type = message.getMessageType();
                if (messageTypeClass.containsKey(type) && messageTypeClass.get(type) != clazz) {
                    throw new Exception(String.format("Duplicate message type %d maps to %s and %s", type, clazz, messageTypeClass.get(type)));
                }
                Localise.logDebug(logger, "Registering %1$s (%2$s) as %3$d", clazz.getName(), tag, type);
                messageClassType.put(clazz, type);
                messageTypeClass.put(type, clazz);
                messageClassTag.put(clazz, tag);
                Set<Class<?>> classes = messageTagClasses.get(tag);
                if (classes == null) {
                    classes = new HashSet();
                    messageTagClasses.put(tag, classes);
                }
                classes.add(clazz);
            }
            catch (NoSuchMethodException e) {
                Localise.logError(logger, "Message type %s does not have a null constructor", clazz.getName());
            }
            catch (SecurityException e) {
                Localise.logError(logger, e, "Security exception getting constructor for %s", clazz.getName());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Localise.logError(logger, e, "Could not instantiate %s", clazz.getName());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        for (Class<?> c : clazz.getDeclaredClasses()) {
            MessageSerializer.registerMessages(c);
        }
    }

    public static Class<?> getMessageClass(Integer type) {
        return messageTypeClass.get(type);
    }

    public static Set<Class<?>> getMessageClasses() {
        return messageClassType.keySet();
    }

    public static Set<Class<?>> getMessageClasses(String tag) {
        return messageTagClasses.get(tag);
    }

    public static Set<String> getMessageTags() {
        return messageTagClasses.keySet();
    }

    public static String getMessageTag(Class<?> clazz) {
        return messageClassTag.get(clazz);
    }

    public static Integer getMessageType(Class<?> clazz) {
        return messageClassType.get(clazz);
    }

    public Message<?> duplicate(Message<?> object) {
        return this.read(this.write(object));
    }

    public byte[] write(Message<?> object) {
        Class<?> clazz = object.getClass();
        Integer type = MessageSerializer.getMessageType(clazz);
        if (type == null) {
            MessageSerializer.registerMessages(clazz);
            type = MessageSerializer.getMessageType(clazz);
        }
        byte[] data = object.toProto().build().toByteArray();
        ByteBuffer buffer = ByteBuffer.allocate(data.length + 4);
        buffer.putInt(type);
        buffer.put(data);
        return buffer.array();
    }

    public Message<?> read(byte[] buffer) {
        int type = ByteBuffer.wrap(buffer).getInt();
        Class<?> clazz = MessageSerializer.getMessageClass(type);
        if (clazz == null) {
            Localise.logError(logger, "Unknown message type received: %d", type);
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return ((Message)constructor.newInstance(new Object[0])).fromProto(Arrays.copyOfRange(buffer, 4, buffer.length));
        }
        catch (IllegalAccessException | InstantiationException e) {
            Localise.logError(logger, e, "Could not instantiate %s", clazz.getName());
            return null;
        }
        catch (Exception e) {
            Localise.logError(logger, e, "Parsing message %1$s %2$s", clazz.getName(), Arrays.toString(buffer));
            return null;
        }
    }

    public int getTypeId() {
        return 1;
    }

    public void destroy() {
    }

    static {
        MessageSerializer.registerMessages(ACL.class);
        MessageSerializer.registerMessages(ACLList.class);
        MessageSerializer.registerMessages(ACLCommand.class);
        MessageSerializer.registerMessages(ACLQuery.class);
        MessageSerializer.registerMessages(ACLUpdate.class);
        MessageSerializer.registerMessages(AgentQuery.class);
        MessageSerializer.registerMessages(Announcement.class);
        MessageSerializer.registerMessages(AnnouncementCommand.class);
        MessageSerializer.registerMessages(Calendar.class);
        MessageSerializer.registerMessages(CalendarCommand.class);
        MessageSerializer.registerMessages(CalendarQuery.class);
        MessageSerializer.registerMessages(CalendarJobsQuery.class);
        MessageSerializer.registerMessages(CalendarUpdate.class);
        MessageSerializer.registerMessages(Change.class);
        MessageSerializer.registerMessages(Connection.class);
        MessageSerializer.registerMessages(ConnectionQuery.class);
        MessageSerializer.registerMessages(ConnectionAuthenticate.class);
        MessageSerializer.registerMessages(ChangeQuery.class);
        MessageSerializer.registerMessages(Config.class);
        MessageSerializer.registerMessages(BooleanConfig.class);
        MessageSerializer.registerMessages(IntegerConfig.class);
        MessageSerializer.registerMessages(PeriodConfig.class);
        MessageSerializer.registerMessages(StringConfig.class);
        MessageSerializer.registerMessages(ConfigCommand.class);
        MessageSerializer.registerMessages(ConfigQuery.class);
        MessageSerializer.registerMessages(ConfigProperty.class);
        MessageSerializer.registerMessages(ConnectionRegister.class);
        MessageSerializer.registerMessages(ConnectionUpdate.class);
        MessageSerializer.registerMessages(DateQuery.class);
        MessageSerializer.registerMessages(HostACL.class);
        MessageSerializer.registerMessages(HostACLList.class);
        MessageSerializer.registerMessages(HostACLQuery.class);
        MessageSerializer.registerMessages(HostACLCommand.class);
        MessageSerializer.registerMessages(Protected.class);
        MessageSerializer.registerMessages(ICalendar.class);
        MessageSerializer.registerMessages(ICalendarData.class);
        MessageSerializer.registerMessages(ICalendarCommand.class);
        MessageSerializer.registerMessages(ICalendarQuery.class);
        MessageSerializer.registerMessages(ICalendarUpdate.class);
        MessageSerializer.registerMessages(Group.class);
        MessageSerializer.registerMessages(GroupQuery.class);
        MessageSerializer.registerMessages(Job.class);
        MessageSerializer.registerMessages(JobMode.class);
        MessageSerializer.registerMessages(License.class);
        MessageSerializer.registerMessages(LicenseQuery.class);
        MessageSerializer.registerMessages(LicenseCommand.class);
        MessageSerializer.registerMessages(Limit.class);
        MessageSerializer.registerMessages(LimitQuery.class);
        MessageSerializer.registerMessages(LimitReset.class);
        MessageSerializer.registerMessages(CalendarUpdateJob.class);
        MessageSerializer.registerMessages(ClusterQuery.class);
        MessageSerializer.registerMessages(CommandJob.class);
        MessageSerializer.registerMessages(ContainerJob.class);
        MessageSerializer.registerMessages(CustomJob.class);
        MessageSerializer.registerMessages(MailJob.class);
        MessageSerializer.registerMessages(TriggerJob.class);
        MessageSerializer.registerMessages(SQLJob.class);
        MessageSerializer.registerMessages(URLJob.class);
        MessageSerializer.registerMessages(JobCommand.class);
        MessageSerializer.registerMessages(JobControl.class);
        MessageSerializer.registerMessages(JobExecute.class);
        MessageSerializer.registerMessages(JobHistoryClear.class);
        MessageSerializer.registerMessages(JobHistoryQuery.class);
        MessageSerializer.registerMessages(JobOutputQuery.class);
        MessageSerializer.registerMessages(JobQuery.class);
        MessageSerializer.registerMessages(JobStatusQuery.class);
        MessageSerializer.registerMessages(Name.class);
        MessageSerializer.registerMessages(MonthlySchedule.class);
        MessageSerializer.registerMessages(Output.class);
        MessageSerializer.registerMessages(PersistCommand.class);
        MessageSerializer.registerMessages(PersistUpdate.class);
        MessageSerializer.registerMessages(Property.class);
        MessageSerializer.registerMessages(PropertyList.class);
        MessageSerializer.registerMessages(PropertyCommand.class);
        MessageSerializer.registerMessages(PropertyQuery.class);
        MessageSerializer.registerMessages(PropertyUpdate.class);
        MessageSerializer.registerMessages(Protected.class);
        MessageSerializer.registerMessages(ProtectedCommand.class);
        MessageSerializer.registerMessages(ProtectedList.class);
        MessageSerializer.registerMessages(ProtectedQuery.class);
        MessageSerializer.registerMessages(Queue.class);
        MessageSerializer.registerMessages(QueueCommand.class);
        MessageSerializer.registerMessages(QueueQuery.class);
        MessageSerializer.registerMessages(Result.class);
        MessageSerializer.registerMessages(Role.class);
        MessageSerializer.registerMessages(RoleCommand.class);
        MessageSerializer.registerMessages(RoleQuery.class);
        MessageSerializer.registerMessages(RoleUpdate.class);
        MessageSerializer.registerMessages(ServerQuery.class);
        MessageSerializer.registerMessages(ServiceQuery.class);
        MessageSerializer.registerMessages(ServiceCommand.class);
        MessageSerializer.registerMessages(ServiceStatus.class);
        MessageSerializer.registerMessages(Status.class);
        MessageSerializer.registerMessages(Topic.class);
        MessageSerializer.registerMessages(TopicQuery.class);
        MessageSerializer.registerMessages(JobUpdate.class);
        MessageSerializer.registerMessages(User.class);
        MessageSerializer.registerMessages(UserCommand.class);
        MessageSerializer.registerMessages(UserPassword.class);
        MessageSerializer.registerMessages(UserQuery.class);
        MessageSerializer.registerMessages(UserRefresh.class);
        MessageSerializer.registerMessages(UserUpdate.class);
        MessageSerializer.registerMessages(Version.class);
    }
}

