/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.security.ACL;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoACL;
import com.google.protobuf.InvalidProtocolBufferException;

public class ACLCommand
extends AbstractCommandMessage<ACLCommand> {
    private static final String MESSAGE_TAG = "command";
    private ACL acl;
    private Action action;

    public ACLCommand() {
    }

    public ACLCommand(ACL acl, Action action) {
        this.acl = acl;
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public Name getName() {
        return this.acl.getName();
    }

    public ACL getACL() {
        return this.acl;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoACL.Command.Builder toProto() {
        ProtoACL.Command.Builder builder = ProtoACL.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAcl(this.acl.toProto());
        builder.setAction(this.action.toProto());
        return builder;
    }

    @Override
    public ACLCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoACL.Command proto = ProtoACL.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.acl = new ACL().fromProto(proto.getAcl().toByteArray());
        this.action = Action.fromProto(proto.getAction());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private ACL acl;
        private Action action;

        public Response() {
        }

        public Response(ACLCommand command) {
            this.acl = command.acl;
            this.action = command.action;
        }

        public Name getName() {
            return this.acl.getName();
        }

        public Action getAction() {
            return this.action;
        }

        public Response setAction(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoACL.CommandResponse.Builder toProto() {
            ProtoACL.CommandResponse.Builder builder = ProtoACL.CommandResponse.newBuilder();
            builder.setAcl(this.acl.toProto());
            builder.setAction(this.action.toProto());
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoACL.CommandResponse proto = ProtoACL.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.acl = new ACL().fromProto(proto.getAcl().toByteArray());
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

        static EnumMap<Action, ProtoACL.Command.Action> actionMap;

        public static Action fromProto(ProtoACL.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoACL.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoACL.Command.Action>(Action.class, ProtoACL.Command.Action.class);
        }
    }
}

