/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.security.ACL;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoACL;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ACLQuery
extends AbstractCommandMessage<ACLQuery> {
    private static final String MESSAGE_TAG = "query";
    private Name name = null;
    private String userName = null;
    private List<String> changeIds = new ArrayList<String>();

    public ACLQuery() {
    }

    public ACLQuery(Name name) {
        this.name = name;
    }

    public ACLQuery(Name name, List<String> changeIds) {
        this.name = name;
        if (changeIds != null) {
            this.changeIds.addAll(changeIds);
        }
    }

    public Name getName() {
        return this.name;
    }

    public ACLQuery setName(Name name) {
        this.name = name;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public ACLQuery setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public ACLQuery addChangeId(String changeId) {
        this.changeIds.add(changeId);
        return this;
    }

    public List<String> getChangeIds() {
        return this.changeIds;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoACL.Query.Builder toProto() {
        ProtoACL.Query.Builder builder = ProtoACL.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.name != null) {
            builder.setName(this.name.toProto());
        }
        if (!StringUtils.isNullOrEmpty(this.userName)) {
            builder.setUserName(this.userName);
        }
        builder.addAllChangeIds(this.changeIds);
        return builder;
    }

    @Override
    public ACLQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoACL.Query proto = ProtoACL.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = proto.hasName() ? new Name(proto.getName()) : null;
        this.userName = proto.hasUserName() ? proto.getUserName() : null;
        this.changeIds.clear();
        this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<String> changeIds = new ArrayList<String>();
        private List<List<ACL>> acls = new ArrayList<List<ACL>>();

        public Response() {
        }

        public Response(Collection<ACL> acls) {
            this.addACLs(acls);
        }

        public Response addACLs(Collection<ACL> acls) {
            this.acls.add(new ArrayList<ACL>(acls));
            return this;
        }

        public List<List<ACL>> getACLs() {
            return this.acls;
        }

        public List<ACL> getACLs(int index) {
            return index < this.acls.size() ? this.acls.get(index) : new ArrayList<ACL>();
        }

        public Response addChangeId(String changeId) {
            this.changeIds.add(changeId);
            return this;
        }

        public List<String> getChangeIds() {
            return this.changeIds;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.acls.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoACL.QueryResponse.Builder toProto() {
            ProtoACL.QueryResponse.Builder builder = ProtoACL.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.addAllChangeIds(this.changeIds);
            for (Collection collection : this.acls) {
                ProtoACL.ACLList.Builder aclsBuilder = ProtoACL.ACLList.newBuilder();
                for (ACL acl : collection) {
                    aclsBuilder.addValues(acl.toProto());
                }
                builder.addAcls(aclsBuilder);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoACL.QueryResponse proto = ProtoACL.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.changeIds.clear();
            this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
            this.acls.clear();
            for (ProtoACL.ACLList aclsProto : proto.getAclsList()) {
                ArrayList<ACL> aclCollection = new ArrayList<ACL>();
                for (ProtoACL.ACL acl : aclsProto.getValuesList()) {
                    aclCollection.add(new ACL().fromProto(acl.toByteArray()));
                }
                this.acls.add(aclCollection);
            }
            return this;
        }
    }
}

