/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoAgent;
import com.beyondcron.messaging.proto.ProtoConnection;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class AgentQuery
extends AbstractCommandMessage<AgentQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();

    public AgentQuery() {
    }

    public AgentQuery(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public AgentQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoAgent.Query.Builder toProto() {
        ProtoAgent.Query.Builder builder = ProtoAgent.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        return builder;
    }

    @Override
    public AgentQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConnection.Query proto = ProtoConnection.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<Connection> agents = new ArrayList<Connection>();

        public Response addAgent(Connection agent) {
            this.agents.add(agent);
            return this;
        }

        public List<Connection> getAgents() {
            return this.agents;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.agents.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoAgent.QueryResponse.Builder toProto() {
            ProtoAgent.QueryResponse.Builder builder = ProtoAgent.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Connection agent : this.agents) {
                builder.addAgent(agent.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoAgent.QueryResponse proto = ProtoAgent.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.agents.clear();
            for (ProtoConnection.Connection agent : proto.getAgentList()) {
                this.agents.add(new Connection().fromProto(agent.toByteArray()));
            }
            return this;
        }
    }
}

