/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoAnnouncement;
import com.google.protobuf.InvalidProtocolBufferException;

public class Announcement
implements Message<Announcement> {
    private static final String MESSAGE_TAG = "announcement";
    private String message;
    private String userName;
    private Level level;

    public Announcement() {
    }

    public Announcement(String message, String userName, Level level) {
        this.message = message;
        this.userName = userName;
        this.level = level;
    }

    public String getMessage() {
        return this.message;
    }

    public Announcement setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public Announcement setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public Announcement setLevel(Level level) {
        this.level = level;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoAnnouncement.Announcement.Builder toProto() {
        ProtoAnnouncement.Announcement.Builder builder = ProtoAnnouncement.Announcement.newBuilder();
        builder.setMessage(this.message);
        builder.setUserName(this.userName);
        if (this.level != Level.INFO) {
            builder.setLevel(this.level.toProto());
        }
        return builder;
    }

    @Override
    public Announcement fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoAnnouncement.Announcement proto = ProtoAnnouncement.Announcement.parseFrom(data);
        this.message = proto.getMessage();
        this.userName = proto.getUserName();
        this.level = Level.fromProto(proto.getLevel());
        return this;
    }

    public String toString() {
        return String.format("%s: %s - %s", new Object[]{this.level, this.userName, this.message});
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

        private static final EnumMap<Level, ProtoAnnouncement.Announcement.Level> levelMap;

        public static Level fromProto(ProtoAnnouncement.Announcement.Level level) {
            return levelMap.getA(level);
        }

        public ProtoAnnouncement.Announcement.Level toProto() {
            return levelMap.getB(this);
        }

        static {
            levelMap = new EnumMap<Level, ProtoAnnouncement.Announcement.Level>(Level.class, ProtoAnnouncement.Announcement.Level.class);
        }
    }
}

