/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.Announcement;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoAnnouncement;
import com.google.protobuf.InvalidProtocolBufferException;

public class AnnouncementCommand
extends AbstractCommandMessage<AnnouncementCommand> {
    private static final String MESSAGE_TAG = "command";
    private String message;
    private Announcement.Level level;

    public AnnouncementCommand() {
    }

    public AnnouncementCommand(String message) {
        this(message, Announcement.Level.INFO);
    }

    public AnnouncementCommand(String message, Announcement.Level level) {
        this.message = message;
        this.level = level;
    }

    public Announcement.Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoAnnouncement.Command.Builder toProto() {
        ProtoAnnouncement.Command.Builder builder = ProtoAnnouncement.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setMessage(this.message);
        if (this.level != Announcement.Level.INFO) {
            builder.setLevel(this.level.toProto());
        }
        return builder;
    }

    @Override
    public AnnouncementCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoAnnouncement.Command proto = ProtoAnnouncement.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.message = proto.getMessage();
        this.level = Announcement.Level.fromProto(proto.getLevel());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoAnnouncement.CommandResponse.Builder toProto() {
            ProtoAnnouncement.CommandResponse.Builder builder = ProtoAnnouncement.CommandResponse.newBuilder();
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoAnnouncement.CommandResponse proto = ProtoAnnouncement.CommandResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }
}

