/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.messaging.proto.ProtoCalendar;
import com.google.protobuf.InvalidProtocolBufferException;

public class CalendarCommand
extends AbstractCommandMessage<CalendarCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private Name name;
    private Calendar calendar = null;

    public CalendarCommand() {
    }

    public CalendarCommand(Calendar calendar, Action action) {
        this.name = calendar.getName();
        this.action = action;
        this.calendar = calendar;
    }

    public CalendarCommand(Name name, Action action) {
        this.name = name;
        this.action = action;
    }

    public Name getName() {
        return this.name;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCalendar.Command.Builder toProto() {
        ProtoCalendar.Command.Builder builder = ProtoCalendar.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeGroup(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setName(this.name.toProto());
        if (this.calendar != null) {
            builder.setCalendar(this.calendar.toProto());
        }
        return builder;
    }

    @Override
    public CalendarCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCalendar.Command proto = ProtoCalendar.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeGroup();
        this.action = Action.fromProto(proto.getAction());
        this.name = new Name(proto.getName());
        this.calendar = proto.hasCalendar() ? new Calendar().fromProto(proto.getCalendar().toByteArray()) : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name;
        private Action action;

        public Response() {
        }

        public Response(CalendarCommand command) {
            this.name = command.name;
            this.action = command.action;
        }

        public Name getName() {
            return this.name;
        }

        public Action getAction() {
            return this.action;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoCalendar.CommandResponse.Builder toProto() {
            ProtoCalendar.CommandResponse.Builder builder = ProtoCalendar.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            builder.setName(this.name.toProto());
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoCalendar.CommandResponse proto = ProtoCalendar.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.name = new Name(proto.getName());
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE,
        REFRESH;

        static EnumMap<Action, ProtoCalendar.Command.Action> actionMap;

        public static Action fromProto(ProtoCalendar.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoCalendar.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoCalendar.Command.Action>(Action.class, ProtoCalendar.Command.Action.class);
        }
    }
}

