/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.Change;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoChange;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class ChangeQuery
extends AbstractCommandMessage<ChangeQuery> {
    private static final String MESSAGE_TAG = "query";
    private Name name;
    private Type type;
    private String changeId = null;
    private long startTimestamp = -1L;
    private long endTimestamp = -1L;

    public ChangeQuery() {
    }

    public ChangeQuery(Name name, Type type) {
        this.name = name;
        this.type = type;
    }

    public ChangeQuery(String changeId) {
        this.name = BlissUtils.ACL_DIR_CHANGES;
        this.type = Type.COMMIT;
        this.changeId = changeId;
    }

    public ChangeQuery(long startTimestamp) {
        this.name = BlissUtils.ACL_DIR_CHANGES;
        this.type = Type.COMMIT;
        this.startTimestamp = startTimestamp;
    }

    public Name getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getChangeId() {
        return this.changeId;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoChange.Query.Builder toProto() {
        ProtoChange.Query.Builder builder = ProtoChange.Query.newBuilder();
        builder.setClientId(this.clientId);
        builder.setName(this.name.toProto());
        builder.setType(this.type.toProto());
        if (!StringUtils.isNullOrEmpty(this.changeId)) {
            builder.setChangeId(this.changeId);
        }
        if (this.startTimestamp >= 0L) {
            builder.setStartTimestamp(this.startTimestamp);
        }
        if (this.endTimestamp >= 0L) {
            builder.setEndTimestamp(this.endTimestamp);
        }
        return builder;
    }

    @Override
    public ChangeQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoChange.Query proto = ProtoChange.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = new Name(proto.getName());
        this.type = Type.fromProto(proto.getType());
        this.changeId = proto.hasChangeId() ? proto.getChangeId() : null;
        this.startTimestamp = proto.getStartTimestamp();
        this.endTimestamp = proto.getEndTimestamp();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Type type;
        private List<Change> changes = new ArrayList<Change>();

        public Response() {
        }

        public Response(ChangeQuery query) {
            this.type = query.type;
        }

        public Response addChanges(List<Change> changes) {
            this.changes.addAll(changes);
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public List<Change> getChanges() {
            return this.changes;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.changes.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoChange.QueryResponse.Builder toProto() {
            ProtoChange.QueryResponse.Builder builder = ProtoChange.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setType(this.type.toProto());
            for (Change change : this.changes) {
                builder.addChanges(change.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoChange.QueryResponse proto = ProtoChange.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.type = Type.fromProto(proto.getType());
            for (ProtoChange.Change change : proto.getChangesList()) {
                this.changes.add(new Change().fromProto(change.toByteArray()));
            }
            return this;
        }
    }

    public static enum Type {
        ACL("acl", "acl"),
        ACLS("acls", "acl"),
        CALENDAR("cal", "job"),
        CONFIG("config", "config"),
        JOB("job", "calendar"),
        PROPERTY("property", "property"),
        PROPERTIES("properties", "property"),
        COMMIT("commit", "commit");

        private String tag;
        private String label;
        static EnumMap<Type, ProtoChange.Query.Type> typeMap;

        private Type(String tag, String label) {
            this.tag = tag;
            this.label = label;
        }

        public String getTag() {
            return this.tag;
        }

        public String getLabel() {
            return this.label;
        }

        public static Type fromProto(ProtoChange.Query.Type type) {
            return typeMap.getA(type);
        }

        public ProtoChange.Query.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoChange.Query.Type>(Type.class, ProtoChange.Query.Type.class);
        }
    }
}

