/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;

public class ConfigCommand
extends AbstractCommandMessage<ConfigCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private String name;
    private String value;

    public ConfigCommand() {
    }

    public ConfigCommand(String name, String value) {
        this.name = name;
        this.value = value;
        this.action = value != null ? Action.SET : Action.UNSET;
    }

    public Action getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoConfig.Command.Builder toProto() {
        ProtoConfig.Command.Builder builder = ProtoConfig.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setName(this.name);
        if (this.value != null) {
            builder.setValue(this.value);
        }
        return builder;
    }

    @Override
    public ConfigCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.Command proto = ProtoConfig.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.name = proto.getName();
        this.value = proto.hasValue() ? proto.getValue() : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private String name;
        private Action action;

        public Response() {
        }

        public Response(ConfigCommand command) {
            this.name = command.getName();
            this.action = command.action;
        }

        public String getName() {
            return this.name;
        }

        public Action getAction() {
            return this.action;
        }

        public Response setAction(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoConfig.CommandResponse.Builder toProto() {
            ProtoConfig.CommandResponse.Builder builder = ProtoConfig.CommandResponse.newBuilder();
            builder.setName(this.name);
            builder.setAction(this.action.toProto());
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoConfig.CommandResponse proto = ProtoConfig.CommandResponse.parseFrom(data);
            this.name = proto.getName();
            this.action = Action.fromProto(proto.getAction());
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        SET,
        UNSET;

        static EnumMap<Action, ProtoConfig.Command.Action> actionMap;

        public static Action fromProto(ProtoConfig.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoConfig.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoConfig.Command.Action>(Action.class, ProtoConfig.Command.Action.class);
        }
    }
}

