/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.core.config.Config;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigQuery
extends AbstractCommandMessage<ConfigQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();
    private boolean startup = false;
    private boolean hidden = false;
    private List<String> changeIds = new ArrayList<String>();

    public ConfigQuery() {
    }

    public ConfigQuery(String name) {
        this.setFilter(new Filter(name));
    }

    public ConfigQuery(String name, List<String> changeIds) {
        this.filter = new Filter(name);
        if (changeIds != null) {
            this.changeIds.addAll(changeIds);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ConfigQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public boolean getStartup() {
        return this.startup;
    }

    public ConfigQuery setStartup(boolean startup) {
        this.startup = startup;
        return this;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public ConfigQuery setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public ConfigQuery addChangeId(String changeId) {
        this.changeIds.add(changeId);
        return this;
    }

    public List<String> getChangeIds() {
        return this.changeIds;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoConfig.Query.Builder toProto() {
        ProtoConfig.Query.Builder builder = ProtoConfig.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        if (this.startup) {
            builder.setStartup(true);
        }
        if (this.hidden) {
            builder.setHidden(true);
        }
        builder.addAllChangeIds(this.changeIds);
        return builder;
    }

    @Override
    public ConfigQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.Query proto = ProtoConfig.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        this.startup = proto.getStartup();
        this.hidden = proto.getHidden();
        this.changeIds.clear();
        this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<String> changeIds = new ArrayList<String>();
        private List<Config> configs = new ArrayList<Config>();

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.configs.isEmpty();
        }

        public Response addChangeId(String changeId) {
            this.changeIds.add(changeId);
            return this;
        }

        public List<String> getChangeIds() {
            return this.changeIds;
        }

        public Response addConfig(Config config) {
            if (config != null) {
                this.configs.add(config);
            }
            return this;
        }

        public List<Config> getConfigs() {
            return this.configs;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoConfig.QueryResponse.Builder toProto() {
            ProtoConfig.QueryResponse.Builder builder = ProtoConfig.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.addAllChangeIds(this.changeIds);
            for (Config config : this.configs) {
                builder.addConfigs(config.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoConfig.QueryResponse proto = ProtoConfig.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.changeIds.clear();
            this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
            this.configs.clear();
            for (ProtoConfig.Config config : proto.getConfigsList()) {
                this.configs.add(Config.parseFromProto(config.toByteArray()));
            }
            return this;
        }
    }
}

