/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Configs;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoConnection;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.invoke.CallSite;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Connection
implements Comparable<Connection>,
JSON<Connection>,
Message<Connection> {
    private static final String MESSAGE_TAG = "connection";
    public static final String JSON_ADDRESS = "address";
    public static final String JSON_ARCH = "arch";
    public static final String JSON_AUTHENTICATED = "authenticated";
    public static final String JSON_CLIENT = "client";
    public static final String JSON_HOST = "host";
    public static final String JSON_ID = "id";
    public static final String JSON_JAVA = "java";
    public static final String JSON_NAME = "name";
    public static final String JSON_OS = "os";
    public static final String JSON_STATE = "state";
    public static final String JSON_UPDATE_TIME = "updateTime";
    public static final String JSON_TYPE = "type";
    public static final String JSON_USER = "user";
    public static final String JSON_VENDOR = "vendor";
    public static final String JSON_VERSION = "version";
    private String id;
    private long updateTime;
    private boolean authenticated = false;
    private String clientUserName;
    private String clientHostName;
    private String clientAddress;
    private String clientName = null;
    private String clientVersion = null;
    private Type clientType = Type.UNKNOWN;
    private State clientState = State.ONLINE;
    private String osUserName = null;
    private String osName = null;
    private String osArch = null;
    private String osVersion = null;
    private String javaVersion = null;
    private String javaVendor = null;

    public Connection() {
    }

    public Connection(String id, String clientType) {
        this(id, Type.valueOf(clientType), Program.getUserName());
    }

    public Connection(String id, String clientType, String clientUserName) {
        this(id, Type.valueOf(clientType), clientUserName);
    }

    public Connection(String id, Type clientType) {
        this(id, clientType, Program.getUserName());
    }

    public Connection(String id, Type clientType, String clientUserName) {
        this.id = id;
        this.updateTime = System.currentTimeMillis();
        this.clientUserName = clientUserName;
        this.clientName = Program.getName();
        this.clientVersion = Program.getVersion().toString();
        this.clientType = clientType;
        this.clientHostName = ((String)Configs.get("BEYONDCRON_HOST_NAME")).toLowerCase();
        this.osUserName = System.getProperty("user.name");
        this.osName = System.getProperty("os.name");
        this.osArch = System.getProperty("os.arch");
        this.osVersion = System.getProperty("os.version");
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
    }

    public boolean isConnected() {
        return this.clientState.equals((Object)State.ONLINE);
    }

    public Connection setConnected(boolean connected) {
        if (connected != this.isConnected()) {
            this.setClientState(connected ? State.ONLINE : State.OFFLINE);
        }
        return this;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public Connection setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String getClientUserName() {
        return this.clientUserName;
    }

    public Connection setClientUserName(String userName) {
        this.clientUserName = userName;
        return this;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public Connection setClientHostName(String hostName) {
        this.clientHostName = hostName.toLowerCase();
        return this;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public InetSocketAddress getSocketAddress() {
        int i = this.clientAddress.indexOf(58);
        return new InetSocketAddress(this.clientAddress.substring(0, i), Integer.parseInt(this.clientAddress.substring(++i)));
    }

    public Connection setSocketAddress(com.beyondcron.core.InetSocketAddress address) {
        this.clientAddress = address.toString();
        return this;
    }

    public String getClient() {
        return this.clientName + " " + this.clientVersion;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public Type getClientType() {
        return this.clientType;
    }

    public State getClientState() {
        return this.clientState;
    }

    public Connection setClientState(State state) {
        this.clientState = state;
        this.updateTime = System.currentTimeMillis();
        return this;
    }

    public String getOsUserName() {
        return this.osUserName;
    }

    public String getOS() {
        return this.osName + " " + this.osArch + " " + this.osVersion;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getJava() {
        return this.javaVersion + " " + this.javaVendor;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    @Override
    public int compareTo(Connection that) {
        int i = this.clientHostName.compareTo(that.clientHostName);
        if (i != 0) {
            return i;
        }
        return this.id.compareTo(that.id);
    }

    @Override
    public Connection fromJSON(JSONObject data) throws JSONException {
        return null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_ID, this.id);
        json.put(JSON_UPDATE_TIME, this.updateTime);
        json.put(JSON_AUTHENTICATED, this.authenticated);
        JSONObject object = new JSONObject();
        object.put(JSON_USER, this.clientUserName);
        object.put(JSON_HOST, this.clientHostName);
        object.put(JSON_ADDRESS, this.clientAddress);
        object.put(JSON_STATE, this.clientState.toString());
        object.put(JSON_TYPE, this.clientType.toString());
        object.put(JSON_NAME, StringUtils.get(this.clientName));
        object.put(JSON_VERSION, StringUtils.get(this.clientVersion));
        json.put(JSON_CLIENT, object);
        object = new JSONObject();
        object.put(JSON_USER, StringUtils.get(this.osUserName));
        object.put(JSON_NAME, StringUtils.get(this.osName));
        object.put(JSON_ARCH, StringUtils.get(this.osArch));
        object.put(JSON_VERSION, StringUtils.get(this.osVersion));
        object.put(JSON_USER, StringUtils.get(this.osUserName));
        object.put(JSON_USER, StringUtils.get(this.osUserName));
        json.put(JSON_OS, object);
        object = new JSONObject();
        object.put(JSON_VERSION, StringUtils.get(this.javaVersion));
        object.put(JSON_VENDOR, StringUtils.get(this.javaVendor));
        json.put(JSON_JAVA, object);
        return json;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoConnection.Connection.Builder toProto() {
        ProtoConnection.Connection.Builder builder = ProtoConnection.Connection.newBuilder();
        builder.setId(this.id);
        builder.setUpdateTime(this.updateTime);
        if (!this.authenticated) {
            builder.setAuthenticated(this.authenticated);
        }
        builder.setClientUserName(this.clientUserName);
        builder.setClientHostName(this.clientHostName);
        builder.setClientAddress(this.clientAddress);
        builder.setClientState(this.clientState.toProto());
        builder.setClientType(this.clientType.toProto());
        if (!StringUtils.isNullOrEmpty(this.clientName)) {
            builder.setClientName(this.clientName);
        }
        if (!StringUtils.isNullOrEmpty(this.clientVersion)) {
            builder.setClientVersion(this.clientVersion);
        }
        if (!StringUtils.isNullOrEmpty(this.osUserName)) {
            builder.setOsUser(this.osUserName);
        }
        if (!StringUtils.isNullOrEmpty(this.osName)) {
            builder.setOsName(this.osName);
        }
        if (!StringUtils.isNullOrEmpty(this.osArch)) {
            builder.setOsArch(this.osArch);
        }
        if (!StringUtils.isNullOrEmpty(this.osVersion)) {
            builder.setOsVersion(this.osVersion);
        }
        if (!StringUtils.isNullOrEmpty(this.javaVersion)) {
            builder.setJavaVersion(this.javaVersion);
        }
        if (!StringUtils.isNullOrEmpty(this.javaVendor)) {
            builder.setJavaVendor(this.javaVendor);
        }
        return builder;
    }

    @Override
    public Connection fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConnection.Connection proto = ProtoConnection.Connection.parseFrom(data);
        this.id = proto.getId();
        this.updateTime = proto.getUpdateTime();
        this.authenticated = proto.getAuthenticated();
        this.clientUserName = proto.getClientUserName();
        this.clientHostName = proto.getClientHostName();
        this.clientAddress = proto.getClientAddress();
        this.clientState = State.fromProto(proto.getClientState());
        this.clientName = proto.hasClientName() ? proto.getClientName() : "";
        this.clientVersion = proto.hasClientVersion() ? proto.getClientVersion() : "";
        this.clientType = Type.fromProto(proto.getClientType());
        this.osUserName = proto.hasOsUser() ? proto.getOsUser() : "";
        this.osName = proto.hasOsName() ? proto.getOsName() : "";
        this.osArch = proto.hasOsArch() ? proto.getOsArch() : "";
        this.osVersion = proto.hasOsVersion() ? proto.getOsVersion() : "";
        this.javaVersion = proto.hasJavaVersion() ? proto.getJavaVersion() : "";
        this.javaVendor = proto.hasJavaVendor() ? proto.getJavaVendor() : "";
        return this;
    }

    public String toString() {
        ArrayList<CallSite> values = new ArrayList<CallSite>();
        values.add((CallSite)((Object)("time: " + this.id)));
        values.add((CallSite)((Object)("updated: " + new Date(this.updateTime))));
        values.add((CallSite)((Object)("authenticated:" + this.authenticated)));
        values.add((CallSite)((Object)("client: " + this.clientName)));
        values.add((CallSite)((Object)("client type: " + this.clientType)));
        values.add((CallSite)((Object)("client state: " + this.clientState)));
        values.add((CallSite)((Object)("client version: " + this.clientVersion)));
        values.add((CallSite)((Object)("client user: " + this.clientUserName)));
        values.add((CallSite)((Object)("client host: " + this.clientHostName)));
        values.add((CallSite)((Object)("client address: " + this.clientAddress)));
        values.add((CallSite)((Object)("OS: " + this.osName)));
        values.add((CallSite)((Object)("OS arch: " + this.osArch)));
        values.add((CallSite)((Object)("OS version: " + this.osVersion)));
        values.add((CallSite)((Object)("OS user: " + this.osUserName)));
        return StringUtils.join("\n", values);
    }

    public static enum State {
        OFFLINE,
        ONLINE;

        public static EnumMap<State, ProtoConnection.Connection.State> stateMap;

        public static State fromProto(ProtoConnection.Connection.State state) {
            return stateMap.getA(state);
        }

        public ProtoConnection.Connection.State toProto() {
            return stateMap.getB(this);
        }

        static {
            stateMap = new EnumMap<State, ProtoConnection.Connection.State>(State.class, ProtoConnection.Connection.State.class);
        }
    }

    public static enum Type {
        UNKNOWN("Unknown"),
        AGENT("Agent"),
        AGENT_SSH("SSH agent"),
        COMMAND("Command"),
        SERVER("Server"),
        WEB("Web");

        private String label;
        public static EnumMap<Type, ProtoConnection.Connection.Type> typeMap;

        private Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Type fromProto(ProtoConnection.Connection.Type type) {
            return typeMap.getA(type);
        }

        public ProtoConnection.Connection.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoConnection.Connection.Type>(Type.class, ProtoConnection.Connection.Type.class);
        }
    }
}

