/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoConnection;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;

public class ConnectionRegister
implements Message<ConnectionRegister> {
    static final Logger logger = LogUtils.getLogger(ConnectionRegister.class);
    private static final String MESSAGE_TAG = "command";
    private Connection connection;
    private boolean authenticate = true;
    private String password;
    private String clusterPassword;

    public ConnectionRegister() {
    }

    public ConnectionRegister(Connection connection, String password) {
        this(connection, password, true);
    }

    public ConnectionRegister(Connection connection, boolean authenticate) {
        this(connection, User.randomPassword(), authenticate);
    }

    public ConnectionRegister(Connection connection, String password, boolean authenticate) {
        this.connection = connection;
        this.password = password;
        this.authenticate = authenticate;
        try {
            this.clusterPassword = Configs.getPassword("BEYONDCRON_CLUSTER_PASSWORD");
        }
        catch (IOException e) {
            this.clusterPassword = (String)Configs.getDefault("BEYONDCRON_CLUSTER_PASSWORD");
            Localise.logFatal(logger, "Could not get cluster password %1$s using default - %2$s", Configs.get("BEYONDCRON_CLUSTER_PASSWORD"), e.getMessage());
        }
        this.clusterPassword = this.clusterPassword + Configs.get("BEYONDCRON_CLUSTER_NAME");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClusterPassword() {
        return this.clusterPassword;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public String toString() {
        return this.connection.toString() + "\n" + this.password;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoConnection.Register.Builder toProto() {
        ProtoConnection.Register.Builder builder = ProtoConnection.Register.newBuilder();
        builder.setConnection(this.connection.toProto());
        builder.setAuthenticate(this.authenticate);
        if (this.authenticate) {
            builder.setPassword(this.password);
        }
        if (!StringUtils.isNullOrEmpty(this.clusterPassword)) {
            builder.setClusterPassword(this.clusterPassword);
        }
        return builder;
    }

    @Override
    public ConnectionRegister fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConnection.Register proto = ProtoConnection.Register.parseFrom(data);
        this.connection = new Connection().fromProto(proto.getConnection().toByteArray());
        this.authenticate = proto.getAuthenticate();
        if (this.authenticate) {
            this.password = proto.getPassword();
        }
        this.clusterPassword = proto.hasClusterPassword() ? proto.getClusterPassword() : "";
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private boolean authenticated = false;
        private Map<String, String> properties = new TreeMap<String, String>();

        public Response() {
        }

        public Response(Result result, boolean authenticated) {
            this.result = result;
            this.authenticated = authenticated;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        public boolean isAuthenticated() {
            return this.authenticated;
        }

        public Response setAuthenticated(boolean authenticated) {
            this.authenticated = authenticated;
            return this;
        }

        public Response addProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public String toString() {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add("Result: " + this.result.toString());
            if (this.properties.size() > 0) {
                values.add("Properties:");
                for (String key : this.properties.keySet()) {
                    values.add("  " + key + " = " + this.properties.get(key));
                }
            }
            return StringUtils.join("\n", values);
        }

        public ProtoConnection.RegisterResponse.Builder toProto() {
            ProtoConnection.RegisterResponse.Builder builder = ProtoConnection.RegisterResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setAuthenticated(this.authenticated);
            for (String name : this.properties.keySet()) {
                ProtoProperty.Property.Builder property = ProtoProperty.Property.newBuilder();
                String value = this.properties.get(name);
                property.setName(name);
                if (value != null && value.length() > 0) {
                    property.setValue(value);
                }
                builder.addProperty(property);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoConnection.RegisterResponse proto = ProtoConnection.RegisterResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.authenticated = proto.getAuthenticated();
            this.properties.clear();
            for (ProtoProperty.Property property : proto.getPropertyList()) {
                this.properties.put(property.getName(), property.hasValue() ? property.getValue() : null);
            }
            return this;
        }
    }
}

