/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoDate;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.ZonedDateTime;

public class DateQuery
extends AbstractCommandMessage<DateQuery> {
    private static final String MESSAGE_TAG = "query";

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoDate.Query.Builder toProto() {
        ProtoDate.Query.Builder builder = ProtoDate.Query.newBuilder();
        builder.setClientId(this.clientId);
        return builder;
    }

    @Override
    public DateQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoDate.Query proto = ProtoDate.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private ZonedDateTime date;

        public Response() {
        }

        public Response(ZonedDateTime date) {
            this.date = date;
        }

        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoDate.QueryResponse.Builder toProto() {
            ProtoDate.QueryResponse.Builder builder = ProtoDate.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setDate(this.date.toString());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoDate.QueryResponse proto = ProtoDate.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.date = ZonedDateTime.parse(proto.getDate());
            return this;
        }
    }
}

