/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoHostACL;
import com.google.protobuf.InvalidProtocolBufferException;

public class HostACLCommand
extends AbstractCommandMessage<HostACLCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private HostACL acl;
    private String userRole;

    public HostACLCommand() {
    }

    public HostACLCommand(HostACL acl, Action action) {
        this.action = action;
        this.acl = acl;
        this.userRole = null;
    }

    public HostACLCommand(String userRole, Action action) {
        if (action != Action.DELETE) {
            throw new IllegalArgumentException("this constructor only supports the DELETE action");
        }
        this.action = action;
        this.userRole = userRole;
        this.acl = null;
    }

    public Action getAction() {
        return this.action;
    }

    public HostACL getACL() {
        return this.acl;
    }

    public String getUserRole() {
        return this.userRole;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoHostACL.Command.Builder toProto() {
        ProtoHostACL.Command.Builder builder = ProtoHostACL.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        if (this.acl != null) {
            builder.setAcl(this.acl.toProto());
        }
        if (this.userRole != null) {
            builder.setUserRole(this.userRole);
        }
        return builder;
    }

    @Override
    public HostACLCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoHostACL.Command proto = ProtoHostACL.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.acl = proto.hasAcl() ? new HostACL().fromProto(proto.getAcl().toByteArray()) : null;
        this.userRole = proto.hasUserRole() ? proto.getUserRole() : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Action action;
        private String userRole;
        private HostACL acl;

        public Response() {
        }

        public Response(HostACLCommand command) {
            this.action = command.action;
            this.acl = command.acl;
            this.userRole = command.userRole;
        }

        public Action getAction() {
            return this.action;
        }

        public HostACL getACL() {
            return this.acl;
        }

        public String getUserRole() {
            return this.userRole;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoHostACL.CommandResponse.Builder toProto() {
            ProtoHostACL.CommandResponse.Builder builder = ProtoHostACL.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            if (this.acl != null) {
                builder.setAcl(this.acl.toProto());
            }
            if (this.userRole != null) {
                builder.setUserRole(this.userRole);
            }
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoHostACL.CommandResponse proto = ProtoHostACL.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.acl = proto.hasAcl() ? new HostACL().fromProto(proto.getAcl().toByteArray()) : null;
            this.userRole = proto.hasUserRole() ? proto.getUserRole() : null;
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        SET,
        DELETE;

        static EnumMap<Action, ProtoHostACL.Command.Action> actionMap;

        public static Action fromProto(ProtoHostACL.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoHostACL.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoHostACL.Command.Action>(Action.class, ProtoHostACL.Command.Action.class);
        }
    }
}

