/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class JobStatusQuery
extends AbstractCommandMessage<JobStatusQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();
    private Status.Filter statusFilter = null;

    public Filter getFilter() {
        return this.filter;
    }

    public JobStatusQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Status.Filter getStatusFilter() {
        return this.statusFilter;
    }

    public JobStatusQuery setStatusFilter(Status.Filter statusFilter) {
        this.statusFilter = statusFilter;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.StatusQuery.Builder toProto() {
        ProtoJob.StatusQuery.Builder builder = ProtoJob.StatusQuery.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        if (this.statusFilter != null && !this.statusFilter.isEmpty()) {
            for (Status.Result result : this.statusFilter.getResultFilters()) {
                builder.addResultFilters(result.toProto());
            }
            for (Status.State state : this.statusFilter.getStateFilters()) {
                builder.addStateFilters(state.toProto());
            }
        }
        return builder;
    }

    @Override
    public JobStatusQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.StatusQuery proto = ProtoJob.StatusQuery.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        this.statusFilter = new Status.Filter();
        for (ProtoJob.Status.Result result : proto.getResultFiltersList()) {
            this.statusFilter.add(Status.Result.fromProto(result));
        }
        for (ProtoJob.Status.State state : proto.getStateFiltersList()) {
            this.statusFilter.add(Status.State.fromProto(state));
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<Status> statuses = new ArrayList<Status>();

        public Response addStatus(Status status) {
            this.statuses.add(status);
            return this;
        }

        public List<Status> getStatuses() {
            return this.statuses;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.statuses.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoJob.StatusQueryResponse.Builder toProto() {
            ProtoJob.StatusQueryResponse.Builder builder = ProtoJob.StatusQueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Status status : this.statuses) {
                builder.addStatuses(status.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoJob.StatusQueryResponse proto = ProtoJob.StatusQueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.statuses.clear();
            for (ProtoJob.Status status : proto.getStatusesList()) {
                this.statuses.add(new Status().fromProto(status.toByteArray()));
            }
            return this;
        }
    }
}

