/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.MessageSerializer;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.proto.ProtoPersist;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;

public class PersistUpdate
implements Message<PersistUpdate> {
    private static final String MESSAGE_TAG = "update";
    private int changeGroup;
    private long time;
    private Connection connection;
    private Type type;
    private Name name;
    private Message message;

    public PersistUpdate() {
    }

    public PersistUpdate(int changeGroup, long time, Connection connection, Type type, Name name, Message message) {
        this.changeGroup = changeGroup;
        this.time = time;
        this.connection = connection;
        this.type = type;
        this.name = name;
        this.message = message;
    }

    public int getChangeGroup() {
        return this.changeGroup;
    }

    public long getTime() {
        return this.time;
    }

    public Type getType() {
        return this.type;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Name getName() {
        return this.name;
    }

    public Message getMessage() {
        return this.message;
    }

    public String toString() {
        return this.changeGroup + " " + this.type + " " + this.name + " " + this.message;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoPersist.Update.Builder toProto() {
        ProtoPersist.Update.Builder builder = ProtoPersist.Update.newBuilder();
        builder.setChangeGroup(this.changeGroup);
        builder.setTime(this.time);
        if (this.connection != null) {
            builder.setConnection(this.connection.toProto());
        }
        builder.setType(this.type.toProto());
        builder.setName(this.name.toProto());
        builder.setMessage(ByteString.copyFrom((byte[])new MessageSerializer().write(this.message)));
        return builder;
    }

    @Override
    public PersistUpdate fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoPersist.Update proto = ProtoPersist.Update.parseFrom(data);
        this.changeGroup = proto.getChangeGroup();
        this.time = proto.getTime();
        this.connection = proto.hasConnection() ? new Connection().fromProto(proto.getConnection().toByteArray()) : null;
        this.type = Type.fromProto(proto.getType());
        this.name = new Name().fromProto(proto.getName().toByteArray());
        this.message = new MessageSerializer().read(proto.getMessage().toByteArray());
        return this;
    }

    public static enum Type {
        SAVE,
        REMOVE,
        COMMIT;

        static EnumMap<Type, ProtoPersist.Update.Type> typeMap;

        public static Type fromProto(ProtoPersist.Update.Type type) {
            return typeMap.getA(type);
        }

        public ProtoPersist.Update.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoPersist.Update.Type>(Type.class, ProtoPersist.Update.Type.class);
        }
    }
}

