/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PropertyQuery
extends AbstractCommandMessage<PropertyQuery> {
    private static final String MESSAGE_TAG = "query";
    private Name name = null;
    private boolean nameOnly = true;
    private List<String> changeIds = new ArrayList<String>();

    public PropertyQuery() {
    }

    public PropertyQuery(Name name) {
        this(name, true);
    }

    public PropertyQuery(Name name, boolean nameOnly) {
        this.name = name;
        this.nameOnly = nameOnly;
    }

    public PropertyQuery(Name name, List<String> changeIds) {
        this.name = name;
        if (changeIds != null) {
            this.changeIds.addAll(changeIds);
        }
    }

    public Name getName() {
        return this.name;
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public PropertyQuery addChangeId(String changeId) {
        this.changeIds.add(changeId);
        return this;
    }

    public List<String> getChangeIds() {
        return this.changeIds;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoProperty.Query.Builder toProto() {
        ProtoProperty.Query.Builder builder = ProtoProperty.Query.newBuilder();
        builder.setClientId(this.clientId);
        builder.setName(this.name.toProto());
        if (!this.nameOnly) {
            builder.setNameOnly(this.nameOnly);
        }
        builder.addAllChangeIds(this.changeIds);
        return builder;
    }

    @Override
    public PropertyQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoProperty.Query proto = ProtoProperty.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = proto.hasName() ? new Name(proto.getName()) : null;
        this.nameOnly = proto.getNameOnly();
        this.changeIds.clear();
        this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Name name = Name.ROOT;
        private boolean nameOnly = true;
        private List<String> changeIds = new ArrayList<String>();
        private List<List<Property>> properties = new ArrayList<List<Property>>();

        protected Response() {
        }

        public Response(PropertyQuery query) {
            this.name = query.getName();
            this.nameOnly = query.isNameOnly();
        }

        public Response addProperties(Collection<Property> properties) {
            this.properties.add(new ArrayList<Property>(properties));
            return this;
        }

        public Name getName() {
            return this.name;
        }

        public boolean isNameOnly() {
            return this.nameOnly;
        }

        public List<List<Property>> getProperties() {
            return this.properties;
        }

        public List<Property> getProperties(int index) {
            return index < this.properties.size() ? this.properties.get(index) : new ArrayList<Property>();
        }

        public Response addChangeId(String changeId) {
            this.changeIds.add(changeId);
            return this;
        }

        public List<String> getChangeIds() {
            return this.changeIds;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoProperty.QueryResponse.Builder toProto() {
            ProtoProperty.QueryResponse.Builder builder = ProtoProperty.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setName(this.name.toProto());
            if (!this.nameOnly) {
                builder.setNameOnly(this.nameOnly);
            }
            builder.addAllChangeIds(this.changeIds);
            for (Collection collection : this.properties) {
                ProtoProperty.PropertyList.Builder propertiesBuilder = ProtoProperty.PropertyList.newBuilder();
                for (Property property : collection) {
                    propertiesBuilder.addProperties(property.toProto());
                }
                builder.addProperties(propertiesBuilder);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoProperty.QueryResponse proto = ProtoProperty.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.name = new Name().fromProto(proto.getName().toByteArray());
            this.nameOnly = proto.getNameOnly();
            this.changeIds.clear();
            this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
            this.properties.clear();
            for (ProtoProperty.PropertyList propertiesProto : proto.getPropertiesList()) {
                ArrayList<Property> propertyCollection = new ArrayList<Property>();
                for (ProtoProperty.Property property : propertiesProto.getPropertiesList()) {
                    propertyCollection.add(new Property().fromProto(property.toByteArray()));
                }
                this.properties.add(propertyCollection);
            }
            return this;
        }
    }
}

