/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.core.security.Protected;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoProtected;
import com.google.protobuf.InvalidProtocolBufferException;

public class ProtectedCommand
extends AbstractCommandMessage<ProtectedCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private Protected.Type type;
    private String value;

    public ProtectedCommand() {
    }

    public ProtectedCommand(Protected.Type type, String value, Action action) {
        this.action = action;
        this.type = type;
        this.value = value;
    }

    public Action getAction() {
        return this.action;
    }

    public Protected.Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoProtected.Command.Builder toProto() {
        ProtoProtected.Command.Builder builder = ProtoProtected.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setType(this.type.toProto());
        builder.setValue(this.value);
        return builder;
    }

    @Override
    public ProtectedCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoProtected.Command proto = ProtoProtected.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.type = Protected.Type.fromProto(proto.getType());
        this.value = proto.getValue();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Action action;
        private Protected.Type type;
        private String value;

        public Response() {
        }

        public Response(ProtectedCommand command) {
            this.action = command.action;
            this.type = command.type;
            this.value = command.value;
        }

        public Action getAction() {
            return this.action;
        }

        public Protected.Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoProtected.CommandResponse.Builder toProto() {
            ProtoProtected.CommandResponse.Builder builder = ProtoProtected.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            builder.setType(this.type.toProto());
            builder.setValue(this.value);
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoProtected.CommandResponse proto = ProtoProtected.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.type = Protected.Type.fromProto(proto.getType());
            this.value = proto.getValue();
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        ADD,
        DELETE;

        static EnumMap<Action, ProtoProtected.Command.Action> actionMap;

        public static Action fromProto(ProtoProtected.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoProtected.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoProtected.Command.Action>(Action.class, ProtoProtected.Command.Action.class);
        }
    }
}

