/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.core.security.Protected;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoProtected;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProtectedQuery
extends AbstractCommandMessage<ProtectedQuery> {
    private static final String MESSAGE_TAG = "query";
    private Protected.Type type;
    private List<String> changeIds = new ArrayList<String>();

    public ProtectedQuery() {
    }

    public ProtectedQuery(Protected.Type type) {
        this.type = type;
    }

    public ProtectedQuery(Protected.Type type, Collection<String> changeIds) {
        this.type = type;
        if (changeIds != null) {
            this.changeIds.addAll(changeIds);
        }
    }

    public ProtectedQuery addChangeId(String changeId) {
        this.changeIds.add(changeId);
        return this;
    }

    public List<String> getChangeIds() {
        return this.changeIds;
    }

    public Protected.Type getType() {
        return this.type;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoProtected.Query.Builder toProto() {
        ProtoProtected.Query.Builder builder = ProtoProtected.Query.newBuilder();
        builder.setClientId(this.clientId);
        builder.setType(this.type.toProto());
        builder.addAllChangeIds(this.changeIds);
        return builder;
    }

    @Override
    public ProtectedQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoProtected.Query proto = ProtoProtected.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.type = Protected.Type.fromProto(proto.getType());
        this.changeIds.clear();
        this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Protected.Type type;
        private List<String> changeIds = new ArrayList<String>();
        private List<List<Protected>> values = new ArrayList<List<Protected>>();

        public Response() {
        }

        public Response(ProtectedQuery query) {
            this.type = query.getType();
        }

        public Protected.Type getType() {
            return this.type;
        }

        public Response addChangeId(String changeId) {
            this.changeIds.add(changeId);
            return this;
        }

        public List<String> getChangeIds() {
            return this.changeIds;
        }

        public Response addValues(Collection<Protected> values) {
            this.values.add(new ArrayList<Protected>(values));
            return this;
        }

        public List<List<Protected>> getValues() {
            return this.values;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoProtected.QueryResponse.Builder toProto() {
            ProtoProtected.QueryResponse.Builder builder = ProtoProtected.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setType(this.type.toProto());
            builder.addAllChangeIds(this.changeIds);
            for (List<Protected> valueList : this.values) {
                ProtoProtected.ProtectedList.Builder valueBuilder = ProtoProtected.ProtectedList.newBuilder();
                for (Protected value : valueList) {
                    valueBuilder.addValues(value.toProto());
                }
                builder.addValues(valueBuilder);
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoProtected.QueryResponse proto = ProtoProtected.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.type = Protected.Type.fromProto(proto.getType());
            this.changeIds.clear();
            this.changeIds.addAll((Collection<String>)proto.getChangeIdsList());
            this.values.clear();
            for (ProtoProtected.ProtectedList protectedProto : proto.getValuesList()) {
                ArrayList<Protected> valueList = new ArrayList<Protected>();
                for (ProtoProtected.Protected value : protectedProto.getValuesList()) {
                    valueList.add(new Protected().fromProto(value.toByteArray()));
                }
                this.values.add(valueList);
            }
            return this;
        }
    }
}

