/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoQueue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hazelcast.core.IQueue;
import com.hazelcast.monitor.LocalQueueStats;

public class Queue
implements Message<Queue> {
    private static final String MESSAGE_TAG = "queue";
    private String name = "";
    private long received = 0L;
    private long pending = 0L;
    private long minimumAge = 0L;
    private long maximumAge = 0L;
    private long averageAge = 0L;

    public Queue() {
    }

    public Queue(IQueue queue) {
        LocalQueueStats stats = queue.getLocalQueueStats();
        this.name = queue.getName();
        this.received = stats.getOfferOperationCount();
        this.pending = queue.size();
        this.minimumAge = stats.getMinAge();
        if (this.minimumAge == Long.MAX_VALUE) {
            this.minimumAge = 0L;
        }
        this.maximumAge = stats.getMaxAge();
        if (this.maximumAge == Long.MIN_VALUE) {
            this.maximumAge = 0L;
        }
        this.averageAge = stats.getAvgAge();
    }

    public String getName() {
        return this.name;
    }

    public long getReceived() {
        return this.received;
    }

    public long getPending() {
        return this.pending;
    }

    public long getMinimumAge() {
        return this.minimumAge;
    }

    public long getMaximumAge() {
        return this.maximumAge;
    }

    public long getAverageAge() {
        return this.averageAge;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoQueue.Queue.Builder toProto() {
        ProtoQueue.Queue.Builder builder = ProtoQueue.Queue.newBuilder();
        builder.setName(this.name);
        if (this.pending > 0L) {
            builder.setPending(this.pending);
        }
        if (this.received > 0L) {
            builder.setReceived(this.received);
        }
        if (this.minimumAge != 0L) {
            builder.setMinAge(this.minimumAge);
        }
        if (this.maximumAge != 0L) {
            builder.setMaxAge(this.maximumAge);
        }
        if (this.averageAge != 0L) {
            builder.setAvgAge(this.averageAge);
        }
        return builder;
    }

    @Override
    public Queue fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoQueue.Queue proto = ProtoQueue.Queue.parseFrom(data);
        this.name = proto.getName();
        this.received = proto.getReceived();
        this.pending = proto.getPending();
        this.minimumAge = proto.getMinAge();
        this.maximumAge = proto.getMaxAge();
        this.averageAge = proto.getAvgAge();
        return this;
    }
}

